/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.socket.response.auth;

import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import pro.gravit.launcher.base.events.RequestEvent;
import pro.gravit.launcher.base.events.request.RestoreRequestEvent;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.AuthProviderPair;
import pro.gravit.launchserver.auth.core.AuthCoreProvider;
import pro.gravit.launchserver.auth.core.User;
import pro.gravit.launchserver.auth.core.UserSession;
import pro.gravit.launchserver.auth.protect.AdvancedProtectHandler;
import pro.gravit.launchserver.manangers.AuthManager;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.response.SimpleResponse;
import pro.gravit.launchserver.socket.response.WebSocketServerResponse;
import pro.gravit.launchserver.socket.response.auth.AuthResponse;
import pro.gravit.launchserver.socket.response.auth.CurrentUserResponse;
import pro.gravit.launchserver.socket.response.update.LauncherResponse;

public class RestoreResponse
extends SimpleResponse {
    public static Map<String, ExtendedTokenProvider> providers = new HashMap<String, ExtendedTokenProvider>();
    private static boolean registeredProviders = false;
    public String authId;
    public String accessToken;
    public Map<String, String> extended;
    public boolean needUserInfo;

    public static void registerProviders(LaunchServer server) {
        if (!registeredProviders) {
            providers.put("launcher", new LauncherResponse.LauncherTokenVerifier(server));
            providers.put("publicKey", new AdvancedProtectHandler.PublicKeyTokenVerifier(server));
            providers.put("hardware", new AdvancedProtectHandler.HardwareInfoTokenVerifier(server));
            providers.put("checkServer", new AuthManager.CheckServerVerifier(server));
            registeredProviders = true;
        }
    }

    @Override
    public String getType() {
        return "restore";
    }

    @Override
    public void execute(ChannelHandlerContext ctx, Client client) throws Exception {
        if (this.accessToken == null && !client.isAuth && this.needUserInfo) {
            this.sendError("Invalid request");
            return;
        }
        AuthProviderPair pair = !client.isAuth ? (this.authId == null ? this.server.config.getAuthProviderPair() : this.server.config.getAuthProviderPair(this.authId)) : client.auth;
        if (pair == null) {
            this.sendError("Invalid authId");
            return;
        }
        if (this.accessToken != null) {
            UserSession session;
            try {
                session = pair.core.getUserSessionByOAuthAccessToken(this.accessToken);
            }
            catch (AuthCoreProvider.OAuthAccessTokenExpired e) {
                this.sendError("auth.expiretoken");
                return;
            }
            if (session == null) {
                this.sendError("auth.invalidtoken");
                return;
            }
            User user = session.getUser();
            if (user == null) {
                this.sendError("Internal Auth error: UserSession is broken");
                return;
            }
            client.coreObject = user;
            client.sessionObject = session;
            this.server.authManager.internalAuth(client, client.type == null ? AuthResponse.ConnectTypes.API : client.type, pair, user.getUsername(), user.getUUID(), user.getPermissions(), true);
        }
        ArrayList invalidTokens = new ArrayList(4);
        if (this.extended != null) {
            this.extended.forEach((k, v) -> {
                ExtendedTokenProvider provider = providers.get(k);
                if (provider == null) {
                    return;
                }
                if (!provider.accept(client, pair, (String)v)) {
                    invalidTokens.add(k);
                }
            });
        }
        if (this.needUserInfo && client.isAuth) {
            this.sendResult((RequestEvent)new RestoreRequestEvent(CurrentUserResponse.collectUserInfoFromClient(this.server, client), invalidTokens));
        } else {
            this.sendResult((RequestEvent)new RestoreRequestEvent(invalidTokens));
        }
    }

    @Override
    public WebSocketServerResponse.ThreadSafeStatus getThreadSafeStatus() {
        return WebSocketServerResponse.ThreadSafeStatus.READ_WRITE;
    }

    @FunctionalInterface
    public static interface ExtendedTokenProvider {
        public boolean accept(Client var1, AuthProviderPair var2, String var3);
    }
}

