/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.socket.response.secure;

import io.netty.channel.ChannelHandlerContext;
import pro.gravit.launcher.base.events.RequestEvent;
import pro.gravit.launcher.base.events.request.GetSecureLevelInfoRequestEvent;
import pro.gravit.launchserver.auth.protect.ProtectHandler;
import pro.gravit.launchserver.auth.protect.interfaces.SecureProtectHandler;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.response.SimpleResponse;
import pro.gravit.launchserver.socket.response.WebSocketServerResponse;

public class GetSecureLevelInfoResponse
extends SimpleResponse {
    @Override
    public String getType() {
        return "getSecureLevelInfo";
    }

    @Override
    public void execute(ChannelHandlerContext ctx, Client client) {
        GetSecureLevelInfoRequestEvent response;
        ProtectHandler protectHandler = this.server.config.protectHandler;
        if (!(protectHandler instanceof SecureProtectHandler)) {
            response = new GetSecureLevelInfoRequestEvent(null);
            response.enabled = false;
            this.sendResult((RequestEvent)response);
            return;
        }
        SecureProtectHandler secureProtectHandler = (SecureProtectHandler)((Object)protectHandler);
        if (!secureProtectHandler.allowGetSecureLevelInfo(client)) {
            this.sendError("Access denied");
            return;
        }
        if (client.trustLevel == null) {
            client.trustLevel = new Client.TrustLevel();
        }
        if (client.trustLevel.verifySecureKey == null) {
            client.trustLevel.verifySecureKey = secureProtectHandler.generateSecureLevelKey();
        }
        response = new GetSecureLevelInfoRequestEvent(client.trustLevel.verifySecureKey);
        response.enabled = true;
        this.sendResult((RequestEvent)secureProtectHandler.onGetSecureLevelInfo(response));
    }

    @Override
    public WebSocketServerResponse.ThreadSafeStatus getThreadSafeStatus() {
        return WebSocketServerResponse.ThreadSafeStatus.READ_WRITE;
    }
}

