/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.command.hash;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.command.Command;
import pro.gravit.launchserver.command.hash.IndexAssetCommand;
import pro.gravit.utils.command.CommandException;
import pro.gravit.utils.helper.IOHelper;

public final class UnindexAssetCommand
extends Command {
    private final transient Logger logger = LogManager.getLogger();

    public UnindexAssetCommand(LaunchServer server) {
        super(server);
    }

    public String getArgsDescription() {
        return "[dir] [index] [output-dir]";
    }

    public String getUsageDescription() {
        return "Unindex asset dir (1.7.10+)";
    }

    public void invoke(String ... args) throws Exception {
        JsonObject objects;
        this.verifyArgs(args, 3);
        String inputAssetDirName = IOHelper.verifyFileName((String)args[0]);
        String indexFileName = IOHelper.verifyFileName((String)args[1]);
        String outputAssetDirName = IOHelper.verifyFileName((String)args[2]);
        Path inputAssetDir = this.server.updatesDir.resolve(inputAssetDirName);
        Path outputAssetDir = this.server.updatesDir.resolve(outputAssetDirName);
        if (outputAssetDir.equals(inputAssetDir)) {
            throw new CommandException("Indexed and unindexed asset dirs can't be same");
        }
        this.logger.info("Creating unindexed asset dir: '{}'", (Object)outputAssetDirName);
        Files.createDirectory(outputAssetDir, new FileAttribute[0]);
        this.logger.info("Reading asset index file: '{}'", (Object)indexFileName);
        try (BufferedReader reader = IOHelper.newReader((Path)IndexAssetCommand.resolveIndexFile(inputAssetDir, indexFileName));){
            objects = JsonParser.parseReader((Reader)reader).getAsJsonObject().get("objects").getAsJsonObject();
        }
        this.logger.info("Unindexing {} objects", (Object)objects.size());
        for (Map.Entry member : objects.entrySet()) {
            String name = (String)member.getKey();
            this.logger.info("Unindexing: '{}'", (Object)name);
            String hash = ((JsonElement)member.getValue()).getAsJsonObject().get("hash").getAsString();
            Path source = IndexAssetCommand.resolveObjectFile(inputAssetDir, hash);
            IOHelper.copy((Path)source, (Path)outputAssetDir.resolve(name));
        }
        this.server.syncUpdatesDir(Collections.singleton(outputAssetDirName));
        this.logger.info("Asset successfully unindexed: '{}'", (Object)inputAssetDirName);
    }
}

