/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.command.profiles;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.command.Command;
import pro.gravit.utils.helper.IOHelper;

public class CloneProfileCommand
extends Command {
    private final transient Logger logger = LogManager.getLogger(CloneProfileCommand.class);

    public CloneProfileCommand(LaunchServer server) {
        super(server);
    }

    public String getArgsDescription() {
        return "[profile file name] [new profile title]";
    }

    public String getUsageDescription() {
        return "clone profile and profile dir";
    }

    public void invoke(String ... args) throws Exception {
        ClientProfile profile;
        this.verifyArgs(args, 2);
        Path profilePath = this.server.profilesDir.resolve(args[0].concat(".json"));
        if (!Files.exists(profilePath, new LinkOption[0])) {
            this.logger.error("File {} not found", (Object)profilePath);
        }
        try (BufferedReader reader = IOHelper.newReader((Path)profilePath);){
            profile = (ClientProfile)Launcher.gsonManager.gson.fromJson((Reader)reader, ClientProfile.class);
        }
        profile.setTitle(args[1]);
        profile.setUUID(UUID.randomUUID());
        if (profile.getServers().size() == 1) {
            ((ClientProfile.ServerProfile)profile.getServers().getFirst()).name = args[1];
        }
        this.logger.info("Copy {} to {}", (Object)profile.getDir(), (Object)args[1]);
        Path src = this.server.updatesDir.resolve(profile.getDir());
        Path dest = this.server.updatesDir.resolve(args[1]);
        try (Stream<Path> stream = Files.walk(src, new FileVisitOption[0]);){
            stream.forEach(source -> {
                try {
                    IOHelper.copy((Path)source, (Path)dest.resolve(src.relativize((Path)source)));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        profile.setDir(args[1]);
        Path targetPath = this.server.profilesDir.resolve(args[1].concat(".json"));
        try (BufferedWriter writer = IOHelper.newWriter((Path)targetPath);){
            Launcher.gsonManager.gson.toJson((Object)profile, (Appendable)writer);
        }
        this.logger.info("Profile {} cloned from {}", (Object)args[1], (Object)args[0]);
        this.server.syncProfilesDir();
        this.server.syncUpdatesDir(List.of(args[1]));
    }
}

