/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.command.profiles;

import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.command.Command;
import pro.gravit.launchserver.command.profiles.ListProfilesCommand;
import pro.gravit.utils.helper.IOHelper;

public class DeleteProfileCommand
extends Command {
    private final transient Logger logger = LogManager.getLogger(ListProfilesCommand.class);

    public DeleteProfileCommand(LaunchServer server) {
        super(server);
    }

    public String getArgsDescription() {
        return "[uuid/title]";
    }

    public String getUsageDescription() {
        return "permanently delete profile";
    }

    public void invoke(String ... args) throws Exception {
        this.verifyArgs(args, 1);
        ClientProfile profile = null;
        for (ClientProfile p : this.server.getProfiles()) {
            if (!p.getUUID().toString().equals(args[0]) && !p.getTitle().equals(args[0])) continue;
            profile = p;
            break;
        }
        if (profile == null) {
            this.logger.error("Profile {} not found", (Object)args[0]);
            return;
        }
        Path clientDir = this.server.updatesDir.resolve(profile.getDir()).toAbsolutePath();
        this.logger.warn("THIS ACTION DELETE PROFILE AND ALL FILES IN {}", (Object)clientDir);
        if (!this.showApplyDialog("Continue?")) {
            return;
        }
        this.logger.info("Delete {}", (Object)clientDir);
        IOHelper.deleteDir((Path)clientDir, (boolean)true);
        Path profileFile = profile.getProfileFilePath();
        if (profileFile == null) {
            profileFile = this.server.profilesDir.resolve(profile.getTitle().concat(".json"));
        }
        this.logger.info("Delete {}", (Object)profileFile);
        Files.deleteIfExists(profileFile);
    }
}

