/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.command.profiles;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.command.Command;
import pro.gravit.utils.helper.IOHelper;

public class SaveProfilesCommand
extends Command {
    private final transient Logger logger = LogManager.getLogger();

    public SaveProfilesCommand(LaunchServer server) {
        super(server);
    }

    public static void saveProfile(ClientProfile profile, Path path) throws IOException {
        if (profile.getUUID() == null) {
            profile.setUUID(UUID.randomUUID());
        }
        if (profile.getServers().isEmpty()) {
            ClientProfile.ServerProfile serverProfile = new ClientProfile.ServerProfile();
            serverProfile.isDefault = true;
            serverProfile.name = profile.getTitle();
            serverProfile.serverAddress = profile.getServerAddress();
            serverProfile.serverPort = profile.getServerPort();
            profile.getServers().add(serverProfile);
        }
        try (BufferedWriter w = IOHelper.newWriter((Path)path);){
            Launcher.gsonManager.configGson.toJson((Object)profile, (Appendable)w);
        }
    }

    public String getArgsDescription() {
        return "[profile names...]";
    }

    public String getUsageDescription() {
        return "load and save profile";
    }

    public void invoke(String ... args) throws Exception {
        this.verifyArgs(args, 1);
        if (args.length > 0) {
            for (String profileName : args) {
                ClientProfile profile;
                Path profilePath = this.server.profilesDir.resolve(profileName.concat(".json"));
                if (!Files.exists(profilePath, new LinkOption[0])) {
                    this.logger.error("Profile {} not found", (Object)profilePath.toString());
                    return;
                }
                try (BufferedReader reader = IOHelper.newReader((Path)profilePath);){
                    profile = (ClientProfile)Launcher.gsonManager.configGson.fromJson((Reader)reader, ClientProfile.class);
                }
                SaveProfilesCommand.saveProfile(profile, profilePath);
                this.logger.info("Profile {} save successful", (Object)profilePath.toString());
            }
            this.server.syncProfilesDir();
        }
    }
}

