/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.command.tools;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.binary.tasks.SignJarTask;
import pro.gravit.launchserver.command.Command;
import pro.gravit.utils.helper.IOHelper;

public class SignDirCommand
extends Command {
    private final transient Logger logger = LogManager.getLogger();

    public SignDirCommand(LaunchServer server) {
        super(server);
    }

    public String getArgsDescription() {
        return "[path to dir]";
    }

    public String getUsageDescription() {
        return "sign all jar files into dir";
    }

    public void invoke(String ... args) throws Exception {
        this.verifyArgs(args, 1);
        Path targetDir = Paths.get(args[0], new String[0]);
        if (!IOHelper.isDir((Path)targetDir)) {
            throw new IllegalArgumentException("%s not directory".formatted(targetDir));
        }
        Optional<SignJarTask> task = this.server.launcherBinary.getTaskByClass(SignJarTask.class);
        if (task.isEmpty()) {
            throw new IllegalStateException("SignJarTask not found");
        }
        IOHelper.walk((Path)targetDir, (FileVisitor)new SignJarVisitor(task.get()), (boolean)true);
        this.logger.info("Success signed");
    }

    private class SignJarVisitor
    extends SimpleFileVisitor<Path> {
        private final SignJarTask task;

        public SignJarVisitor(SignJarTask task) {
            this.task = task;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (file.toFile().getName().endsWith(".jar")) {
                Path tmpSign = ((SignDirCommand)SignDirCommand.this).server.dir.resolve("build").resolve(file.toFile().getName());
                SignDirCommand.this.logger.info("Signing jar {}", (Object)file.toString());
                this.task.sign(((SignDirCommand)SignDirCommand.this).server.config.sign, file, tmpSign);
                Files.deleteIfExists(file);
                Files.move(tmpSign, file, new CopyOption[0]);
            }
            return super.visitFile(file, attrs);
        }
    }
}

