/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.command.tools;

import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.binary.tasks.SignJarTask;
import pro.gravit.launchserver.command.Command;

public class SignJarCommand
extends Command {
    private final transient Logger logger = LogManager.getLogger();

    public SignJarCommand(LaunchServer server) {
        super(server);
    }

    public String getArgsDescription() {
        return "[path to file] (path to signed file)";
    }

    public String getUsageDescription() {
        return "sign custom jar";
    }

    public void invoke(String ... args) throws Exception {
        this.verifyArgs(args, 1);
        Path target = Paths.get(args[0], new String[0]);
        Path tmpSign = args.length > 1 ? Paths.get(args[1], new String[0]) : this.server.dir.resolve("build").resolve(target.toFile().getName());
        this.logger.info("Signing jar {} to {}", (Object)target.toString(), (Object)tmpSign.toString());
        Optional<SignJarTask> task = this.server.launcherBinary.getTaskByClass(SignJarTask.class);
        if (task.isEmpty()) {
            throw new IllegalStateException("SignJarTask not found");
        }
        task.get().sign(this.server.config.sign, target, tmpSign);
        if (args.length == 1) {
            this.logger.info("Move temp jar {} to {}", (Object)tmpSign.toString(), (Object)target.toString());
            Files.deleteIfExists(target);
            Files.move(tmpSign, target, new CopyOption[0]);
        }
        this.logger.info("Success signed");
    }
}

