/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver;

import java.nio.file.Path;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.config.LaunchServerConfig;
import pro.gravit.launchserver.config.LaunchServerRuntimeConfig;
import pro.gravit.launchserver.manangers.CertificateManager;
import pro.gravit.launchserver.manangers.KeyAgreementManager;
import pro.gravit.launchserver.modules.impl.LaunchServerModulesManager;
import pro.gravit.utils.command.CommandHandler;

public class LaunchServerBuilder {
    private LaunchServerConfig config;
    private LaunchServerRuntimeConfig runtimeConfig;
    private CommandHandler commandHandler;
    private LaunchServer.LaunchServerEnv env;
    private LaunchServerModulesManager modulesManager;
    private LaunchServer.LaunchServerDirectories directories = new LaunchServer.LaunchServerDirectories();
    private KeyAgreementManager keyAgreementManager;
    private CertificateManager certificateManager;
    private LaunchServer.LaunchServerConfigManager launchServerConfigManager;
    private Integer shardId;

    public LaunchServerBuilder setConfig(LaunchServerConfig config) {
        this.config = config;
        return this;
    }

    public LaunchServerBuilder setEnv(LaunchServer.LaunchServerEnv env) {
        this.env = env;
        return this;
    }

    public LaunchServerBuilder setModulesManager(LaunchServerModulesManager modulesManager) {
        this.modulesManager = modulesManager;
        return this;
    }

    public LaunchServerBuilder setRuntimeConfig(LaunchServerRuntimeConfig runtimeConfig) {
        this.runtimeConfig = runtimeConfig;
        return this;
    }

    public LaunchServerBuilder setCommandHandler(CommandHandler commandHandler) {
        this.commandHandler = commandHandler;
        return this;
    }

    public LaunchServerBuilder setDirectories(LaunchServer.LaunchServerDirectories directories) {
        this.directories = directories;
        return this;
    }

    public LaunchServerBuilder setDir(Path dir) {
        this.directories.dir = dir;
        return this;
    }

    public LaunchServerBuilder setShardId(Integer shardId) {
        this.shardId = shardId;
        return this;
    }

    public LaunchServerBuilder setLaunchServerConfigManager(LaunchServer.LaunchServerConfigManager launchServerConfigManager) {
        this.launchServerConfigManager = launchServerConfigManager;
        return this;
    }

    public LaunchServer build() throws Exception {
        this.directories.collect();
        if (this.launchServerConfigManager == null) {
            this.launchServerConfigManager = new NullLaunchServerConfigManager();
        }
        if (this.keyAgreementManager == null) {
            this.keyAgreementManager = new KeyAgreementManager(this.directories.keyDirectory);
        }
        if (this.shardId == null) {
            this.shardId = Integer.parseInt(System.getProperty("launchserver.shardId", "0"));
        }
        return new LaunchServer(this.directories, this.env, this.config, this.runtimeConfig, this.launchServerConfigManager, this.modulesManager, this.keyAgreementManager, this.commandHandler, this.certificateManager, this.shardId);
    }

    public LaunchServerBuilder setCertificateManager(CertificateManager certificateManager) {
        this.certificateManager = certificateManager;
        return this;
    }

    public void setKeyAgreementManager(KeyAgreementManager keyAgreementManager) {
        this.keyAgreementManager = keyAgreementManager;
    }

    private static class NullLaunchServerConfigManager
    implements LaunchServer.LaunchServerConfigManager {
        private NullLaunchServerConfigManager() {
        }

        @Override
        public LaunchServerConfig readConfig() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LaunchServerRuntimeConfig readRuntimeConfig() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeConfig(LaunchServerConfig config) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeRuntimeConfig(LaunchServerRuntimeConfig config) {
            throw new UnsupportedOperationException();
        }
    }
}

