/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.function.Consumer;
import pro.gravit.launchserver.auth.SQLSourceConfig;

public class HikariSQLSourceConfig
implements SQLSourceConfig {
    private transient HikariDataSource dataSource;
    private String dsClass;
    private Properties dsProps;
    private String driverClass;
    private String jdbcUrl;
    private String username;
    private String password;

    public void init() {
        if (this.dataSource != null) {
            return;
        }
        HikariConfig config = new HikariConfig();
        HikariSQLSourceConfig.consumeIfNotNull(arg_0 -> ((HikariConfig)config).setDataSourceClassName(arg_0), this.dsClass);
        HikariSQLSourceConfig.consumeIfNotNull(arg_0 -> ((HikariConfig)config).setDataSourceProperties(arg_0), this.dsProps);
        HikariSQLSourceConfig.consumeIfNotNull(arg_0 -> ((HikariConfig)config).setDriverClassName(arg_0), this.driverClass);
        HikariSQLSourceConfig.consumeIfNotNull(arg_0 -> ((HikariConfig)config).setJdbcUrl(arg_0), this.jdbcUrl);
        HikariSQLSourceConfig.consumeIfNotNull(arg_0 -> ((HikariConfig)config).setUsername(arg_0), this.username);
        HikariSQLSourceConfig.consumeIfNotNull(arg_0 -> ((HikariConfig)config).setPassword(arg_0), this.password);
        this.dataSource = new HikariDataSource(config);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    @Override
    public void close() {
        this.dataSource.close();
    }

    private static <T> void consumeIfNotNull(Consumer<T> consumer, T val) {
        if (val != null) {
            consumer.accept(val);
        }
    }
}

