/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.password;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launchserver.auth.password.PasswordVerifier;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.SecurityHelper;

public class DigestPasswordVerifier
extends PasswordVerifier {
    private final transient Logger logger = LogManager.getLogger();
    public String algo;

    private byte[] digest(String text) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance(this.algo);
        return digest.digest(IOHelper.encode((String)text));
    }

    @Override
    public boolean check(String encryptedPassword, String password) {
        try {
            byte[] bytes = SecurityHelper.fromHex((String)encryptedPassword);
            return Arrays.equals(bytes, this.digest(password));
        }
        catch (NoSuchAlgorithmException e) {
            this.logger.error("Digest algorithm {} not supported", (Object)this.algo);
            return false;
        }
    }

    @Override
    public String encrypt(String password) {
        try {
            return SecurityHelper.toHex((byte[])this.digest(password));
        }
        catch (NoSuchAlgorithmException e) {
            this.logger.error("Digest algorithm {} not supported", (Object)this.algo);
            return null;
        }
    }
}

