/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.command.service;

import java.io.BufferedReader;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.command.Command;
import pro.gravit.launchserver.components.Component;
import pro.gravit.utils.command.SubCommand;
import pro.gravit.utils.helper.IOHelper;

public class ComponentCommand
extends Command {
    private final transient Logger logger = LogManager.getLogger();

    public ComponentCommand(LaunchServer server) {
        super(server);
        this.childCommands.put("unload", new UnloadCommand());
        this.childCommands.put("load", new LoadCommand());
    }

    public String getArgsDescription() {
        return "[action] [component name] [more args]";
    }

    public String getUsageDescription() {
        return "component manager";
    }

    public void printHelp() {
        this.logger.info("Print help for component:");
        this.logger.info("component unload [componentName]");
        this.logger.info("component load [componentName] [filename]");
    }

    public void invoke(String ... args) throws Exception {
        this.invokeSubcommands(args);
    }

    private class UnloadCommand
    extends SubCommand {
        public UnloadCommand() {
            super("[componentName]", "Unload component");
        }

        public void invoke(String ... args) throws Exception {
            this.verifyArgs(args, 1);
            String componentName = args[0];
            if (componentName == null) {
                throw new IllegalArgumentException("Must set componentName");
            }
            Component component = ((ComponentCommand)ComponentCommand.this).server.config.components.get(componentName);
            if (component == null) {
                ComponentCommand.this.logger.error("Component {} not found", (Object)componentName);
                return;
            }
            if (component instanceof AutoCloseable) {
                AutoCloseable autoCloseable = (AutoCloseable)((Object)component);
                autoCloseable.close();
            }
            ComponentCommand.this.server.unregisterObject("component." + componentName, component);
            ((ComponentCommand)ComponentCommand.this).server.config.components.remove(componentName);
            ComponentCommand.this.logger.info("Component %s unloaded. Use 'config launchserver save' to save changes");
        }
    }

    private class LoadCommand
    extends SubCommand {
        public LoadCommand() {
            super("[componentName] [componentType] (json file)", "Load component");
        }

        public void invoke(String ... args) throws Exception {
            this.verifyArgs(args, 2);
            String componentName = args[0];
            Class componentClass = Component.providers.getClass(args[1]);
            if (componentClass == null) {
                ComponentCommand.this.logger.error("Component type {} not registered", (Object)componentName);
                return;
            }
            try {
                Component component;
                if (args.length > 2) {
                    try (BufferedReader reader = IOHelper.newReader((Path)Paths.get(args[2], new String[0]));){
                        component = (Component)Launcher.gsonManager.configGson.fromJson((Reader)reader, componentClass);
                    }
                } else {
                    component = MethodHandles.publicLookup().findConstructor(componentClass, MethodType.methodType(Void.TYPE)).invoke();
                }
                component.setComponentName(componentName);
                ((ComponentCommand)ComponentCommand.this).server.config.components.put(componentName, component);
                component.init(ComponentCommand.this.server);
                ComponentCommand.this.server.registerObject("component." + componentName, component);
                ComponentCommand.this.logger.info("Component %s ready. Use 'config launchserver save' to save changes");
            }
            catch (Throwable throwable) {
                ComponentCommand.this.logger.error((Object)throwable);
            }
        }
    }
}

