/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.components;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.Reconfigurable;
import pro.gravit.launchserver.binary.tasks.LauncherBuildTask;
import pro.gravit.launchserver.components.Component;
import pro.gravit.utils.command.Command;
import pro.gravit.utils.command.SubCommand;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.SecurityHelper;
import pro.gravit.utils.helper.UnpackHelper;

public class ProGuardComponent
extends Component
implements AutoCloseable,
Reconfigurable {
    private static final Logger logger = LogManager.getLogger();
    public String modeAfter = "MainBuild";
    public String dir = "proguard";
    public List<String> jvmArgs = new ArrayList<String>();
    public boolean enabled = true;
    public boolean mappings = true;
    public transient ProguardConf proguardConf;
    private transient LaunchServer launchServer;
    private transient ProGuardBuildTask buildTask;
    private transient ProGuardMultiReleaseFixer fixerTask;

    public ProGuardComponent() {
        this.jvmArgs.add("-Xmx512M");
    }

    public static boolean checkFXJMods(Path path) {
        if (!IOHelper.exists((Path)path.resolve("javafx.base.jmod"))) {
            return false;
        }
        if (!IOHelper.exists((Path)path.resolve("javafx.graphics.jmod"))) {
            return false;
        }
        return IOHelper.exists((Path)path.resolve("javafx.controls.jmod"));
    }

    public static boolean checkJMods(Path path) {
        return IOHelper.exists((Path)path.resolve("java.base.jmod"));
    }

    public static Path tryFindOpenJFXPath(Path jvmDir) {
        Path debianJfxPath;
        String dirName = jvmDir.getFileName().toString();
        Path parent = jvmDir.getParent();
        if (parent == null) {
            return null;
        }
        Path archJFXPath = parent.resolve(dirName.replace("openjdk", "openjfx")).resolve("jmods");
        if (Files.isDirectory(archJFXPath, new LinkOption[0])) {
            return archJFXPath;
        }
        Path arch2JFXPath = parent.resolve(dirName.replace("jdk", "openjfx")).resolve("jmods");
        if (Files.isDirectory(arch2JFXPath, new LinkOption[0])) {
            return arch2JFXPath;
        }
        if (JVMHelper.OS_TYPE == JVMHelper.OS.LINUX && Files.isDirectory(debianJfxPath = Paths.get("/usr/share/openjfx/jmods", new String[0]), new LinkOption[0])) {
            return debianJfxPath;
        }
        return null;
    }

    @Override
    public void init(LaunchServer launchServer) {
        this.launchServer = launchServer;
        this.proguardConf = new ProguardConf(launchServer, this);
        this.buildTask = new ProGuardBuildTask(launchServer, this.proguardConf, this);
        this.fixerTask = new ProGuardMultiReleaseFixer(launchServer, this, "ProGuard.".concat(this.componentName));
        launchServer.launcherBinary.addAfter(v -> v.getName().startsWith(this.modeAfter), this.buildTask);
        launchServer.launcherBinary.addAfter(v -> v.getName().equals("ProGuard.".concat(this.componentName)), this.fixerTask);
    }

    @Override
    public void close() {
        if (this.launchServer != null && this.buildTask != null) {
            this.launchServer.launcherBinary.tasks.remove(this.buildTask);
        }
    }

    @Override
    public Map<String, Command> getCommands() {
        Map<String, Command> commands = this.defaultCommandsMap();
        commands.put("reset", (Command)new SubCommand("[]", "reset proguard config"){

            public void invoke(String ... args) throws Exception {
                ProGuardComponent.this.proguardConf.prepare(true);
                Files.deleteIfExists(ProGuardComponent.this.proguardConf.mappings);
            }
        });
        commands.put("regen", (Command)new SubCommand("[]", "regenerate proguard dictionary"){

            public void invoke(String ... args) throws Exception {
                ProGuardComponent.this.proguardConf.genWords(true);
            }
        });
        commands.put("clean", (Command)new SubCommand("[]", "clean proguard mappings"){

            public void invoke(String ... args) throws Exception {
                ProGuardComponent.this.proguardConf.prepare(true);
                Files.deleteIfExists(ProGuardComponent.this.proguardConf.mappings);
            }
        });
        return null;
    }

    public static class ProguardConf {
        public static final String[] JAVA9_OPTS = new String[]{"-libraryjars '<java.home>/jmods/'"};
        public static final String[] JAVA8_OPTS = new String[]{"-libraryjars '<java.home>/lib/rt.jar'", "-libraryjars '<java.home>/lib/jce.jar'", "-libraryjars '<java.home>/lib/ext/nashorn.jar'", "-libraryjars '<java.home>/lib/ext/jfxrt.jar'"};
        private static final char[] chars = "1aAbBcC2dDeEfF3gGhHiI4jJkKlL5mMnNoO6pPqQrR7sStT8uUvV9wWxX0yYzZ".toCharArray();
        public final Path proguard;
        public final Path config;
        public final Path mappings;
        public final Path words;
        public final transient LaunchServer srv;
        private final transient ProGuardComponent component;

        public ProguardConf(LaunchServer srv, ProGuardComponent component) {
            this.component = component;
            this.proguard = srv.dir.resolve(component.dir);
            this.config = this.proguard.resolve("proguard.config");
            this.mappings = this.proguard.resolve("mappings.pro");
            this.words = this.proguard.resolve("random.pro");
            this.srv = srv;
        }

        private static String generateString(SecureRandom rand, String lowString, String upString, int il) {
            StringBuilder sb = new StringBuilder(Math.max(il, lowString.length()));
            for (int i = 0; i < lowString.length(); ++i) {
                sb.append(rand.nextBoolean() ? lowString.charAt(i) : upString.charAt(i));
            }
            int toI = il - lowString.length();
            for (int i = 0; i < toI; ++i) {
                sb.append(chars[rand.nextInt(chars.length)]);
            }
            return sb.toString();
        }

        public void buildConfig(List<String> confStrs, Path inputJar, Path outputJar, Path[] jfxPath) {
            this.prepare(false);
            if (this.component.mappings) {
                confStrs.add("-printmapping '" + this.mappings.toFile().getName() + "'");
            }
            confStrs.add("-obfuscationdictionary '" + this.words.toFile().getName() + "'");
            confStrs.add("-injar '" + String.valueOf(inputJar.toAbsolutePath()) + "'");
            confStrs.add("-outjar '" + String.valueOf(outputJar.toAbsolutePath()) + "'");
            Collections.addAll(confStrs, JAVA9_OPTS);
            if (jfxPath != null) {
                for (Path path : jfxPath) {
                    confStrs.add("-libraryjars '%s'".formatted(path.toAbsolutePath()));
                }
            }
            this.srv.launcherBinary.coreLibs.stream().map(e -> "-libraryjars '" + String.valueOf(e.toAbsolutePath()) + "'").forEach(confStrs::add);
            this.srv.launcherBinary.addonLibs.stream().map(e -> "-libraryjars '" + String.valueOf(e.toAbsolutePath()) + "'").forEach(confStrs::add);
            confStrs.add("-classobfuscationdictionary '" + this.words.toFile().getName() + "'");
            confStrs.add("@".concat(this.config.toFile().getName()));
        }

        private void genConfig(boolean force) throws IOException {
            if (IOHelper.exists((Path)this.config) && !force) {
                return;
            }
            Files.deleteIfExists(this.config);
            UnpackHelper.unpack((URL)IOHelper.getResourceURL((String)"pro/gravit/launchserver/defaults/proguard.cfg"), (Path)this.config);
        }

        public void genWords(boolean force) throws IOException {
            if (IOHelper.exists((Path)this.words) && !force) {
                return;
            }
            Files.deleteIfExists(this.words);
            SecureRandom rand = SecurityHelper.newRandom();
            rand.setSeed(SecureRandom.getSeed(32));
            try (PrintWriter out = new PrintWriter(new OutputStreamWriter(IOHelper.newOutput((Path)this.words), IOHelper.UNICODE_CHARSET));){
                String projectName = this.srv.config.projectName.replaceAll("\\W", "");
                String lowName = projectName.toLowerCase();
                String upName = projectName.toUpperCase();
                for (int i = 0; i < Short.MAX_VALUE; ++i) {
                    out.println(ProguardConf.generateString(rand, lowName, upName, 14));
                }
            }
        }

        public void prepare(boolean force) {
            try {
                IOHelper.createParentDirs((Path)this.config);
                this.genWords(force);
                this.genConfig(force);
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
    }

    public static class ProGuardBuildTask
    implements LauncherBuildTask {
        private final LaunchServer server;
        private final ProGuardComponent component;
        private final ProguardConf proguardConf;

        public ProGuardBuildTask(LaunchServer server, ProguardConf conf, ProGuardComponent component) {
            this.server = server;
            this.component = component;
            this.proguardConf = conf;
        }

        @Override
        public String getName() {
            return "ProGuard.".concat(this.component.componentName);
        }

        @Override
        public Path process(Path inputFile) throws IOException {
            Path outputJar = this.server.launcherBinary.nextLowerPath(this);
            if (this.component.enabled) {
                if (!ProGuardComponent.checkJMods(IOHelper.JVM_DIR.resolve("jmods"))) {
                    throw new RuntimeException("Java path: %s is not JDK! Please install JDK".formatted(IOHelper.JVM_DIR));
                }
                Path jfxPath = ProGuardComponent.tryFindOpenJFXPath(IOHelper.JVM_DIR);
                if (ProGuardComponent.checkFXJMods(IOHelper.JVM_DIR.resolve("jmods"))) {
                    logger.debug("JavaFX jmods resolved in JDK path");
                    jfxPath = null;
                } else if (jfxPath != null && ProGuardComponent.checkFXJMods(jfxPath)) {
                    logger.debug("JMods resolved in {}", (Object)jfxPath.toString());
                } else {
                    throw new RuntimeException("JavaFX jmods not found. May be install OpenJFX?");
                }
                try {
                    Path[] pathArray;
                    ArrayList<String> args = new ArrayList<String>();
                    args.add(IOHelper.resolveJavaBin((Path)IOHelper.JVM_DIR).toAbsolutePath().toString());
                    args.addAll(this.component.jvmArgs);
                    args.add("-cp");
                    try (Stream<Path> files = Files.walk(Path.of("libraries", new String[0]), FileVisitOption.FOLLOW_LINKS);){
                        args.add(files.filter(e -> e.getFileName().toString().endsWith(".jar")).map(path -> path.toAbsolutePath().toString()).collect(Collectors.joining(File.pathSeparator)));
                    }
                    args.add("proguard.ProGuard");
                    if (jfxPath == null) {
                        pathArray = new Path[]{};
                    } else {
                        Path[] pathArray2 = new Path[1];
                        pathArray = pathArray2;
                        pathArray2[0] = jfxPath;
                    }
                    this.proguardConf.buildConfig(args, inputFile, outputJar, pathArray);
                    Process process = new ProcessBuilder(new String[0]).command(args).inheritIO().directory(this.proguardConf.proguard.toFile()).start();
                    try {
                        process.waitFor();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (process.exitValue() != 0) {
                        throw new RuntimeException("ProGuard process return %d".formatted(process.exitValue()));
                    }
                }
                catch (Exception e2) {
                    logger.error((Object)e2);
                }
            } else {
                IOHelper.copy((Path)inputFile, (Path)outputJar);
            }
            return outputJar;
        }
    }

    public static class ProGuardMultiReleaseFixer
    implements LauncherBuildTask {
        private final LaunchServer server;
        private final ProGuardComponent component;
        private final String proguardTaskName;

        public ProGuardMultiReleaseFixer(LaunchServer server, ProGuardComponent component, String proguardTaskName) {
            this.server = server;
            this.component = component;
            this.proguardTaskName = proguardTaskName;
        }

        @Override
        public String getName() {
            return "ProGuardMultiReleaseFixer.".concat(this.component.componentName);
        }

        @Override
        public Path process(Path inputFile) throws IOException {
            if (!this.component.enabled) {
                return inputFile;
            }
            LauncherBuildTask task = this.server.launcherBinary.getTaskBefore(x -> this.proguardTaskName.equals(x.getName())).get();
            Path lastPath = this.server.launcherBinary.nextPath(task);
            if (Files.notExists(lastPath, new LinkOption[0])) {
                logger.error("{} not exist. Multi-Release JAR fix not applied!", (Object)lastPath);
                return inputFile;
            }
            Path outputPath = this.server.launcherBinary.nextPath(this);
            try (ZipOutputStream output = new ZipOutputStream(new FileOutputStream(outputPath.toFile()));){
                ZipEntry newEntry;
                ZipEntry entry;
                try (ZipInputStream input = new ZipInputStream(new FileInputStream(inputFile.toFile()));){
                    entry = input.getNextEntry();
                    while (entry != null) {
                        newEntry = new ZipEntry(entry.getName());
                        output.putNextEntry(newEntry);
                        input.transferTo(output);
                        entry = input.getNextEntry();
                    }
                }
                input = new ZipInputStream(new FileInputStream(lastPath.toFile()));
                try {
                    entry = input.getNextEntry();
                    while (entry != null) {
                        if (!entry.getName().startsWith("META-INF/versions")) {
                            entry = input.getNextEntry();
                            continue;
                        }
                        newEntry = new ZipEntry(entry.getName());
                        output.putNextEntry(newEntry);
                        input.transferTo(output);
                        entry = input.getNextEntry();
                    }
                }
                finally {
                    input.close();
                }
            }
            return outputPath;
        }
    }
}

