/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver;

import io.netty.channel.Channel;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyStore;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launcher.base.events.RequestEvent;
import pro.gravit.launcher.base.events.request.ProfilesRequestEvent;
import pro.gravit.launcher.base.modules.LauncherModule;
import pro.gravit.launcher.base.modules.events.ClosePhase;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launchserver.Reconfigurable;
import pro.gravit.launchserver.auth.AuthProviderPair;
import pro.gravit.launchserver.auth.core.RejectAuthCoreProvider;
import pro.gravit.launchserver.binary.EXELauncherBinary;
import pro.gravit.launchserver.binary.JARLauncherBinary;
import pro.gravit.launchserver.binary.LauncherBinary;
import pro.gravit.launchserver.command.handler.CommandHandler;
import pro.gravit.launchserver.config.LaunchServerConfig;
import pro.gravit.launchserver.config.LaunchServerRuntimeConfig;
import pro.gravit.launchserver.helper.SignHelper;
import pro.gravit.launchserver.launchermodules.LauncherModuleLoader;
import pro.gravit.launchserver.manangers.AuthManager;
import pro.gravit.launchserver.manangers.CertificateManager;
import pro.gravit.launchserver.manangers.ConfigManager;
import pro.gravit.launchserver.manangers.FeaturesManager;
import pro.gravit.launchserver.manangers.KeyAgreementManager;
import pro.gravit.launchserver.manangers.MirrorManager;
import pro.gravit.launchserver.manangers.ReconfigurableManager;
import pro.gravit.launchserver.manangers.UpdatesManager;
import pro.gravit.launchserver.manangers.hook.AuthHookManager;
import pro.gravit.launchserver.modules.events.LaunchServerFullInitEvent;
import pro.gravit.launchserver.modules.events.LaunchServerInitPhase;
import pro.gravit.launchserver.modules.events.LaunchServerLauncherExeInit;
import pro.gravit.launchserver.modules.events.LaunchServerPostInitPhase;
import pro.gravit.launchserver.modules.events.LaunchServerProfilesSyncEvent;
import pro.gravit.launchserver.modules.events.NewLaunchServerInstanceEvent;
import pro.gravit.launchserver.modules.impl.LaunchServerModulesManager;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.handlers.NettyServerSocketHandler;
import pro.gravit.launchserver.socket.response.auth.ProfilesResponse;
import pro.gravit.launchserver.socket.response.auth.RestoreResponse;
import pro.gravit.utils.command.Command;
import pro.gravit.utils.command.SubCommand;
import pro.gravit.utils.helper.CommonHelper;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.SecurityHelper;

public final class LaunchServer
implements Runnable,
AutoCloseable,
Reconfigurable {
    public final Path dir;
    public final LaunchServerEnv env;
    public final Path launcherLibraries;
    public final Path launcherLibrariesCompile;
    public final Path launcherPack;
    public final Path updatesDir;
    public final LaunchServerConfigManager launchServerConfigManager;
    public final Path profilesDir;
    public final Path tmpDir;
    public final Path modulesDir;
    public final Path launcherModulesDir;
    public final Path librariesDir;
    public final LaunchServerRuntimeConfig runtime;
    public final JARLauncherBinary launcherBinary;
    public final LauncherBinary launcherEXEBinary;
    public final AuthHookManager authHookManager;
    public final LaunchServerModulesManager modulesManager;
    public final MirrorManager mirrorManager;
    public final AuthManager authManager;
    public final ReconfigurableManager reconfigurableManager;
    public final ConfigManager configManager;
    public final FeaturesManager featuresManager;
    public final KeyAgreementManager keyAgreementManager;
    public final UpdatesManager updatesManager;
    public final CertificateManager certificateManager;
    public final pro.gravit.utils.command.CommandHandler commandHandler;
    public final NettyServerSocketHandler nettyServerSocketHandler;
    public final ScheduledExecutorService service;
    public final AtomicBoolean started = new AtomicBoolean(false);
    public final LauncherModuleLoader launcherModuleLoader;
    private final Logger logger = LogManager.getLogger();
    public final int shardId;
    public LaunchServerConfig config;
    private volatile Set<ClientProfile> profilesList;

    public LaunchServer(LaunchServerDirectories directories, LaunchServerEnv env, LaunchServerConfig config, LaunchServerRuntimeConfig runtimeConfig, LaunchServerConfigManager launchServerConfigManager, LaunchServerModulesManager modulesManager, KeyAgreementManager keyAgreementManager, pro.gravit.utils.command.CommandHandler commandHandler, CertificateManager certificateManager, int shardId) throws IOException {
        this.dir = directories.dir;
        this.tmpDir = directories.tmpDir;
        this.env = env;
        this.config = config;
        this.launchServerConfigManager = launchServerConfigManager;
        this.modulesManager = modulesManager;
        this.profilesDir = directories.profilesDir;
        this.updatesDir = directories.updatesDir;
        this.keyAgreementManager = keyAgreementManager;
        this.commandHandler = commandHandler;
        this.runtime = runtimeConfig;
        this.certificateManager = certificateManager;
        this.service = Executors.newScheduledThreadPool(config.netty.performance.schedulerThread);
        this.launcherLibraries = directories.launcherLibrariesDir;
        this.launcherLibrariesCompile = directories.launcherLibrariesCompileDir;
        this.launcherPack = directories.launcherPackDir;
        this.modulesDir = directories.modules;
        this.launcherModulesDir = directories.launcherModules;
        this.librariesDir = directories.launcherLibrariesDir;
        this.shardId = shardId;
        if (!Files.isDirectory(this.launcherPack, new LinkOption[0])) {
            Files.createDirectories(this.launcherPack, new FileAttribute[0]);
        }
        config.setLaunchServer(this);
        modulesManager.invokeEvent(new NewLaunchServerInstanceEvent(this));
        this.runtime.verify();
        config.verify();
        this.mirrorManager = new MirrorManager();
        this.reconfigurableManager = new ReconfigurableManager();
        this.authHookManager = new AuthHookManager();
        this.configManager = new ConfigManager();
        this.featuresManager = new FeaturesManager(this);
        this.authManager = new AuthManager(this);
        this.updatesManager = new UpdatesManager(this);
        RestoreResponse.registerProviders(this);
        config.init(ReloadType.FULL);
        this.registerObject("launchServer", this);
        CommandHandler.registerCommands(commandHandler, this);
        modulesManager.invokeEvent((LauncherModule.Event)new LaunchServerInitPhase(this));
        this.launcherBinary = new JARLauncherBinary(this);
        this.launcherEXEBinary = this.binary();
        this.launcherBinary.init();
        this.launcherEXEBinary.init();
        this.syncLauncherBinaries();
        this.launcherModuleLoader = new LauncherModuleLoader(this);
        if (config.components != null) {
            this.logger.debug("Init components");
            config.components.forEach((k, v) -> {
                this.logger.debug("Init component {}", k);
                v.setComponentName((String)k);
                v.init(this);
            });
            this.logger.debug("Init components successful");
        }
        this.launcherModuleLoader.init();
        this.nettyServerSocketHandler = new NettyServerSocketHandler(this);
        if (config.sign.checkCertificateExpired) {
            this.checkCertificateExpired();
            this.service.scheduleAtFixedRate(this::checkCertificateExpired, 24L, 24L, TimeUnit.HOURS);
        }
        modulesManager.invokeEvent((LauncherModule.Event)new LaunchServerPostInitPhase(this));
    }

    public void reload(ReloadType type) throws Exception {
        this.config.close(type);
        Map<String, AuthProviderPair> pairs = null;
        if (type.equals((Object)ReloadType.NO_AUTH)) {
            pairs = this.config.auth;
        }
        this.logger.info("Reading LaunchServer config file");
        this.config = this.launchServerConfigManager.readConfig();
        this.config.setLaunchServer(this);
        if (type.equals((Object)ReloadType.NO_AUTH)) {
            this.config.auth = pairs;
        }
        this.config.verify();
        this.config.init(type);
        if (type.equals((Object)ReloadType.FULL) && this.config.components != null) {
            this.logger.debug("Init components");
            this.config.components.forEach((k, v) -> {
                this.logger.debug("Init component {}", k);
                v.setComponentName((String)k);
                v.init(this);
            });
            this.logger.debug("Init components successful");
        }
        if (!type.equals((Object)ReloadType.NO_AUTH)) {
            this.nettyServerSocketHandler.nettyServer.service.forEachActiveChannels((channel, wsHandler) -> {
                Client client = wsHandler.getClient();
                if (client.auth != null) {
                    client.auth = this.config.getAuthProviderPair(client.auth_id);
                }
            });
        }
    }

    @Override
    public Map<String, Command> getCommands() {
        HashMap<String, Command> commands = new HashMap<String, Command>();
        SubCommand reload = new SubCommand("[type]", "reload launchserver config"){

            public void invoke(String ... args) throws Exception {
                if (args.length == 0) {
                    LaunchServer.this.reload(ReloadType.FULL);
                    return;
                }
                switch (args[0]) {
                    case "full": {
                        LaunchServer.this.reload(ReloadType.FULL);
                        break;
                    }
                    case "no_components": {
                        LaunchServer.this.reload(ReloadType.NO_COMPONENTS);
                        break;
                    }
                    default: {
                        LaunchServer.this.reload(ReloadType.NO_AUTH);
                    }
                }
            }
        };
        commands.put("reload", (Command)reload);
        SubCommand save = new SubCommand("[]", "save launchserver config"){

            public void invoke(String ... args) throws Exception {
                LaunchServer.this.launchServerConfigManager.writeConfig(LaunchServer.this.config);
                LaunchServer.this.launchServerConfigManager.writeRuntimeConfig(LaunchServer.this.runtime);
                LaunchServer.this.logger.info("LaunchServerConfig saved");
            }
        };
        commands.put("save", (Command)save);
        final LaunchServer instance = this;
        SubCommand resetauth = new SubCommand("authId", "reset auth by id"){

            public void invoke(String ... args) throws Exception {
                this.verifyArgs(args, 1);
                AuthProviderPair pair = LaunchServer.this.config.getAuthProviderPair(args[0]);
                if (pair == null) {
                    LaunchServer.this.logger.error("Pair not found");
                    return;
                }
                pair.core.close();
                pair.core = new RejectAuthCoreProvider();
                pair.core.init(instance, pair);
            }
        };
        commands.put("resetauth", (Command)resetauth);
        return commands;
    }

    public void checkCertificateExpired() {
        if (!this.config.sign.enabled) {
            return;
        }
        try {
            KeyStore keyStore = SignHelper.getStore(Paths.get(this.config.sign.keyStore, new String[0]), this.config.sign.keyStorePass, this.config.sign.keyStoreType);
            Instant date = SignHelper.getCertificateExpired(keyStore, this.config.sign.keyAlias);
            if (date == null) {
                this.logger.debug("The certificate will expire at unlimited");
            } else if (date.minus(Duration.ofDays(30L)).isBefore(Instant.now())) {
                this.logger.warn("The certificate will expire at {}", (Object)date.toString());
            } else {
                this.logger.debug("The certificate will expire at {}", (Object)date.toString());
            }
        }
        catch (Throwable e) {
            this.logger.error("Can't get certificate expire date", e);
        }
    }

    private LauncherBinary binary() {
        LaunchServerLauncherExeInit event = new LaunchServerLauncherExeInit(this, null);
        this.modulesManager.invokeEvent(event);
        if (event.binary != null) {
            return event.binary;
        }
        return new EXELauncherBinary(this);
    }

    public void buildLauncherBinaries() throws IOException {
        this.launcherBinary.build();
        this.launcherEXEBinary.build();
    }

    @Override
    public void close() throws Exception {
        this.service.shutdownNow();
        this.logger.info("Close server socket");
        this.nettyServerSocketHandler.close();
        this.config.close(ReloadType.FULL);
        this.modulesManager.invokeEvent((LauncherModule.Event)new ClosePhase());
        this.logger.info("Save LaunchServer runtime config");
        this.launchServerConfigManager.writeRuntimeConfig(this.runtime);
        this.logger.info("LaunchServer stopped");
    }

    public Set<ClientProfile> getProfiles() {
        return this.profilesList;
    }

    public void setProfiles(Set<ClientProfile> profilesList) {
        this.profilesList = Collections.unmodifiableSet(profilesList);
    }

    public void rebindNettyServerSocket() {
        this.nettyServerSocketHandler.close();
        CommonHelper.newThread((String)"Netty Server Socket Thread", (boolean)false, (Runnable)this.nettyServerSocketHandler).start();
    }

    @Override
    public void run() {
        if (this.started.getAndSet(true)) {
            throw new IllegalStateException("LaunchServer has been already started");
        }
        if (!this.env.equals((Object)LaunchServerEnv.TEST)) {
            JVMHelper.RUNTIME.addShutdownHook(CommonHelper.newThread(null, (boolean)false, () -> {
                try {
                    this.close();
                }
                catch (Exception e) {
                    this.logger.error("LaunchServer close error", (Throwable)e);
                }
            }));
            CommonHelper.newThread((String)"Command Thread", (boolean)true, (Runnable)this.commandHandler).start();
            CommonHelper.newThread((String)"Profiles and updates sync", (boolean)true, () -> {
                try {
                    if (!IOHelper.isDir((Path)this.profilesDir)) {
                        Files.createDirectory(this.profilesDir, new FileAttribute[0]);
                    }
                    this.syncProfilesDir();
                    if (!IOHelper.isDir((Path)this.updatesDir)) {
                        Files.createDirectory(this.updatesDir, new FileAttribute[0]);
                    }
                    this.updatesManager.readUpdatesDir();
                    this.modulesManager.invokeEvent(new LaunchServerProfilesSyncEvent(this));
                }
                catch (IOException e) {
                    this.logger.error("Updates/Profiles not synced", (Throwable)e);
                }
            }).start();
        }
        if (this.config.netty != null) {
            this.rebindNettyServerSocket();
        }
        try {
            this.modulesManager.fullInitializedLaunchServer(this);
            this.modulesManager.invokeEvent(new LaunchServerFullInitEvent(this));
            this.logger.info("LaunchServer started");
        }
        catch (Throwable e) {
            this.logger.error("LaunchServer startup failed", e);
            JVMHelper.RUNTIME.exit(-1);
        }
    }

    public void syncLauncherBinaries() throws IOException {
        this.logger.info("Syncing launcher binaries");
        this.logger.info("Syncing launcher binary file");
        if (!this.launcherBinary.sync()) {
            this.logger.warn("Missing launcher binary file");
        }
        this.logger.info("Syncing launcher EXE binary file");
        if (!this.launcherEXEBinary.sync()) {
            this.logger.warn("Missing launcher EXE binary file");
        }
    }

    public void syncProfilesDir() throws IOException {
        this.logger.info("Syncing profiles dir");
        LinkedList<ClientProfile> newProfies = new LinkedList<ClientProfile>();
        IOHelper.walk((Path)this.profilesDir, (FileVisitor)new ProfilesFileVisitor(newProfies), (boolean)false);
        newProfies.sort(Comparator.comparing(a -> a));
        this.profilesList = Set.copyOf(newProfies);
        if (this.config.netty.sendProfileUpdatesEvent) {
            this.sendUpdateProfilesEvent();
        }
    }

    private void sendUpdateProfilesEvent() {
        if (this.nettyServerSocketHandler == null || this.nettyServerSocketHandler.nettyServer == null || this.nettyServerSocketHandler.nettyServer.service == null) {
            return;
        }
        this.nettyServerSocketHandler.nettyServer.service.forEachActiveChannels((ch, handler) -> {
            Client client = handler.getClient();
            if (client == null || !client.isAuth) {
                return;
            }
            ProfilesRequestEvent event = new ProfilesRequestEvent(ProfilesResponse.getListVisibleProfiles(this, client));
            event.requestUUID = RequestEvent.eventUUID;
            handler.service.sendObject((Channel)ch, event);
        });
    }

    public void syncUpdatesDir(Collection<String> dirs) throws IOException {
        this.updatesManager.syncUpdatesDir(dirs);
    }

    public void registerObject(String name, Object object) {
        if (object instanceof Reconfigurable) {
            this.reconfigurableManager.registerReconfigurable(name, (Reconfigurable)object);
        }
    }

    public void unregisterObject(String name, Object object) {
        if (object instanceof Reconfigurable) {
            this.reconfigurableManager.unregisterReconfigurable(name);
        }
    }

    public static class LaunchServerDirectories {
        public static final String UPDATES_NAME = "updates";
        public static final String PROFILES_NAME = "profiles";
        public static final String TRUSTSTORE_NAME = "truststore";
        public static final String LAUNCHERLIBRARIES_NAME = "launcher-libraries";
        public static final String LAUNCHERLIBRARIESCOMPILE_NAME = "launcher-libraries-compile";
        public static final String LAUNCHERPACK_NAME = "launcher-pack";
        public static final String KEY_NAME = ".keys";
        public static final String MODULES = "modules";
        public static final String LAUNCHER_MODULES = "launcher-modules";
        public static final String LIBRARIES = "libraries";
        public Path updatesDir;
        public Path profilesDir;
        public Path librariesDir;
        public Path launcherLibrariesDir;
        public Path launcherLibrariesCompileDir;
        public Path launcherPackDir;
        public Path keyDirectory;
        public Path dir;
        public Path trustStore;
        public Path tmpDir;
        public Path modules;
        public Path launcherModules;

        public void collect() {
            if (this.updatesDir == null) {
                this.updatesDir = this.getPath(UPDATES_NAME);
            }
            if (this.profilesDir == null) {
                this.profilesDir = this.getPath(PROFILES_NAME);
            }
            if (this.trustStore == null) {
                this.trustStore = this.getPath(TRUSTSTORE_NAME);
            }
            if (this.launcherLibrariesDir == null) {
                this.launcherLibrariesDir = this.getPath(LAUNCHERLIBRARIES_NAME);
            }
            if (this.launcherLibrariesCompileDir == null) {
                this.launcherLibrariesCompileDir = this.getPath(LAUNCHERLIBRARIESCOMPILE_NAME);
            }
            if (this.launcherPackDir == null) {
                this.launcherPackDir = this.getPath(LAUNCHERPACK_NAME);
            }
            if (this.keyDirectory == null) {
                this.keyDirectory = this.getPath(KEY_NAME);
            }
            if (this.modules == null) {
                this.modules = this.getPath(MODULES);
            }
            if (this.launcherModules == null) {
                this.launcherModules = this.getPath(LAUNCHER_MODULES);
            }
            if (this.librariesDir == null) {
                this.librariesDir = this.getPath(LIBRARIES);
            }
            if (this.tmpDir == null) {
                this.tmpDir = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]).resolve("launchserver-%s".formatted(SecurityHelper.randomStringToken()));
            }
        }

        private Path getPath(String dirName) {
            String property = System.getProperty("launchserver.dir." + dirName, null);
            if (property == null) {
                return this.dir.resolve(dirName);
            }
            return Paths.get(property, new String[0]);
        }
    }

    public static enum LaunchServerEnv {
        TEST,
        DEV,
        DEBUG,
        PRODUCTION;

    }

    public static interface LaunchServerConfigManager {
        public LaunchServerConfig readConfig() throws IOException;

        public LaunchServerRuntimeConfig readRuntimeConfig() throws IOException;

        public void writeConfig(LaunchServerConfig var1) throws IOException;

        public void writeRuntimeConfig(LaunchServerRuntimeConfig var1) throws IOException;
    }

    public static enum ReloadType {
        NO_AUTH,
        NO_COMPONENTS,
        FULL;

    }

    private static final class ProfilesFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Collection<ClientProfile> result;
        private final Logger logger = LogManager.getLogger();

        private ProfilesFileVisitor(Collection<ClientProfile> result) {
            this.result = result;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            ClientProfile profile;
            this.logger.info("Syncing '{}' profile", (Object)IOHelper.getFileName((Path)file));
            try (BufferedReader reader = IOHelper.newReader((Path)file);){
                profile = (ClientProfile)Launcher.gsonManager.gson.fromJson((Reader)reader, ClientProfile.class);
            }
            profile.verify();
            profile.setProfileFilePath(file);
            this.result.add(profile);
            return super.visitFile(file, attrs);
        }
    }
}

