/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.manangers;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.core.hasher.HashedDir;
import pro.gravit.launcher.core.serialize.HInput;
import pro.gravit.launcher.core.serialize.HOutput;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.modules.events.LaunchServerUpdatesSyncEvent;
import pro.gravit.utils.helper.IOHelper;

public class UpdatesManager {
    private final LaunchServer server;
    private final Logger logger = LogManager.getLogger();
    private final Path cacheFile;
    private volatile Map<String, HashedDir> updatesDirMap;

    public UpdatesManager(LaunchServer server) {
        this.server = server;
        this.cacheFile = server.dir.resolve(".updates-cache");
    }

    private void writeCache(Path file) throws IOException {
        try (HOutput output = new HOutput(IOHelper.newOutput((Path)file));){
            output.writeLength(this.updatesDirMap.size(), 0);
            for (Map.Entry<String, HashedDir> entry : this.updatesDirMap.entrySet()) {
                output.writeString(entry.getKey(), 0);
                entry.getValue().write(output);
            }
        }
        this.logger.debug("Saved {} updates to cache", (Object)this.updatesDirMap.size());
    }

    private void readCache(Path file) throws IOException {
        HashMap<String, HashedDir> updatesDirMap = new HashMap<String, HashedDir>(16);
        try (HInput input = new HInput(IOHelper.newInput((Path)file));){
            int size = input.readLength(0);
            for (int i = 0; i < size; ++i) {
                String name = input.readString(0);
                HashedDir dir = new HashedDir(input);
                updatesDirMap.put(name, dir);
            }
        }
        this.logger.debug("Found {} updates from cache", (Object)updatesDirMap.size());
        this.updatesDirMap = Collections.unmodifiableMap(updatesDirMap);
    }

    public void readUpdatesFromCache() throws IOException {
        this.readCache(this.cacheFile);
    }

    public void readUpdatesDir() throws IOException {
        if (this.server.config.cacheUpdates && Files.exists(this.cacheFile, new LinkOption[0])) {
            try {
                this.readCache(this.cacheFile);
                return;
            }
            catch (Throwable e) {
                this.logger.error("Read updates cache failed", e);
            }
        }
        this.syncUpdatesDir(null);
    }

    public void syncUpdatesDir(Collection<String> dirs) throws IOException {
        this.logger.info("Syncing updates dir");
        HashMap<String, HashedDir> newUpdatesDirMap = new HashMap<String, HashedDir>(16);
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(this.server.updatesDir);){
            for (Path updateDir : dirStream) {
                HashedDir hdir;
                if (Files.isHidden(updateDir)) continue;
                String name = IOHelper.getFileName((Path)updateDir);
                if (!IOHelper.isDir((Path)updateDir)) {
                    if (IOHelper.isFile((Path)updateDir) || !Stream.of(".jar", ".exe", ".hash").noneMatch(e -> updateDir.toString().endsWith((String)e))) continue;
                    this.logger.warn("Not update dir: '{}'", (Object)name);
                    continue;
                }
                if (dirs != null && !dirs.contains(name) && (hdir = this.updatesDirMap.get(name)) != null) {
                    newUpdatesDirMap.put(name, hdir);
                    continue;
                }
                this.logger.info("Syncing '{}' update dir", (Object)name);
                HashedDir updateHDir = new HashedDir(updateDir, null, true, true);
                newUpdatesDirMap.put(name, updateHDir);
            }
        }
        this.updatesDirMap = Collections.unmodifiableMap(newUpdatesDirMap);
        if (this.server.config.cacheUpdates) {
            try {
                this.writeCache(this.cacheFile);
            }
            catch (Throwable e2) {
                this.logger.error("Write updates cache failed", e2);
            }
        }
        this.server.modulesManager.invokeEvent(new LaunchServerUpdatesSyncEvent(this.server));
    }

    public HashSet<String> getUpdatesList() {
        HashSet<String> set = new HashSet<String>();
        for (Map.Entry<String, HashedDir> entry : this.updatesDirMap.entrySet()) {
            set.add(entry.getKey());
        }
        return set;
    }

    public HashedDir getUpdate(String name) {
        return this.updatesDirMap.get(name);
    }

    public void addUpdate(String name, HashedDir dir) {
        this.updatesDirMap.put(name, dir);
    }
}

