/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.function.Consumer;
import pro.gravit.launchserver.auth.SQLSourceConfig;

public class HikariSQLSourceConfig
implements SQLSourceConfig {
    private volatile transient HikariDataSource dataSource;
    private String dsClass;
    private Properties dsProps;
    private String driverClass;
    private String jdbcUrl;
    private String username;
    private String password;
    private boolean initializeAtStart;

    public void init() {
        if (this.initializeAtStart) {
            this.initializeConnection();
        }
    }

    private void initializeConnection() {
        if (this.dataSource != null) {
            return;
        }
        HikariConfig config = new HikariConfig();
        HikariSQLSourceConfig.consumeIfNotNull(arg_0 -> ((HikariConfig)config).setDataSourceClassName(arg_0), this.dsClass);
        HikariSQLSourceConfig.consumeIfNotNull(arg_0 -> ((HikariConfig)config).setDataSourceProperties(arg_0), this.dsProps);
        HikariSQLSourceConfig.consumeIfNotNull(arg_0 -> ((HikariConfig)config).setDriverClassName(arg_0), this.driverClass);
        HikariSQLSourceConfig.consumeIfNotNull(arg_0 -> ((HikariConfig)config).setJdbcUrl(arg_0), this.jdbcUrl);
        HikariSQLSourceConfig.consumeIfNotNull(arg_0 -> ((HikariConfig)config).setUsername(arg_0), this.username);
        HikariSQLSourceConfig.consumeIfNotNull(arg_0 -> ((HikariConfig)config).setPassword(arg_0), this.password);
        this.dataSource = new HikariDataSource(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws SQLException {
        if (this.dataSource == null && !this.initializeAtStart) {
            HikariSQLSourceConfig hikariSQLSourceConfig = this;
            synchronized (hikariSQLSourceConfig) {
                this.initializeConnection();
            }
        }
        return this.dataSource.getConnection();
    }

    @Override
    public void close() {
        this.dataSource.close();
    }

    private static <T> void consumeIfNotNull(Consumer<T> consumer, T val) {
        if (val != null) {
            consumer.accept(val);
        }
    }
}

