/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.command.profiles;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.command.Command;
import pro.gravit.launchserver.helper.MakeProfileHelper;

public class MakeProfileCommand
extends Command {
    private final transient Logger logger = LogManager.getLogger();

    public MakeProfileCommand(LaunchServer server) {
        super(server);
    }

    public String getArgsDescription() {
        return "[name] [minecraft version] [dir]";
    }

    public String getUsageDescription() {
        return "make profile for any minecraft versions";
    }

    public void invoke(String ... args) throws Exception {
        MakeProfileHelper.MakeProfileOption[] options;
        this.verifyArgs(args, 3);
        ClientProfile.Version version = this.parseClientVersion(args[1]);
        for (MakeProfileHelper.MakeProfileOption option : options = MakeProfileHelper.getMakeProfileOptionsFromDir(this.server.updatesDir.resolve(args[2]), version)) {
            this.logger.info("Detected option {}", (Object)option);
        }
        ClientProfile profile = MakeProfileHelper.makeProfile(version, args[0], options);
        this.server.config.profileProvider.addProfile(profile);
        this.logger.info("Profile {} created", (Object)args[0]);
        this.server.syncProfilesDir();
    }
}

