/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.core;

import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.JwtException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Clock;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.base.ClientPermissions;
import pro.gravit.launcher.base.request.auth.AuthRequest;
import pro.gravit.launcher.base.request.auth.password.AuthPlainPassword;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.AuthException;
import pro.gravit.launchserver.auth.AuthProviderPair;
import pro.gravit.launchserver.auth.MySQLSourceConfig;
import pro.gravit.launchserver.auth.SQLSourceConfig;
import pro.gravit.launchserver.auth.core.AuthCoreProvider;
import pro.gravit.launchserver.auth.core.User;
import pro.gravit.launchserver.auth.core.UserSession;
import pro.gravit.launchserver.auth.core.interfaces.provider.AuthSupportSudo;
import pro.gravit.launchserver.auth.password.PasswordVerifier;
import pro.gravit.launchserver.helper.LegacySessionHelper;
import pro.gravit.launchserver.manangers.AuthManager;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.response.auth.AuthResponse;
import pro.gravit.utils.helper.SecurityHelper;

public abstract class AbstractSQLCoreProvider
extends AuthCoreProvider
implements AuthSupportSudo {
    public final transient Logger logger = LogManager.getLogger();
    public long expireSeconds = TimeUnit.HOURS.toSeconds(1L);
    public String uuidColumn;
    public String usernameColumn;
    public String accessTokenColumn;
    public String passwordColumn;
    public String serverIDColumn;
    public String table;
    public String permissionsTable;
    public String permissionsPermissionColumn;
    public String permissionsUUIDColumn;
    public String rolesTable;
    public String rolesNameColumn;
    public String rolesUUIDColumn;
    public PasswordVerifier passwordVerifier;
    public String customQueryByUUIDSQL;
    public String customQueryByUsernameSQL;
    public String customQueryByLoginSQL;
    public String customQueryPermissionsByUUIDSQL;
    public String customQueryRolesByUserUUID;
    public String customUpdateAuthSQL;
    public String customUpdateServerIdSQL;
    public transient String queryByUUIDSQL;
    public transient String queryByUsernameSQL;
    public transient String queryByLoginSQL;
    public transient String queryPermissionsByUUIDSQL;
    public transient String queryRolesByUserUUID;
    public transient String updateAuthSQL;
    public transient String updateServerIDSQL;

    public abstract SQLSourceConfig getSQLConfig();

    @Override
    public User getUserByUsername(String username) {
        try {
            return this.queryUser(this.queryByUsernameSQL, username);
        }
        catch (Exception e) {
            this.logger.error("SQL error", (Throwable)e);
            return null;
        }
    }

    @Override
    public User getUserByUUID(UUID uuid) {
        try {
            return this.queryUser(this.queryByUUIDSQL, uuid.toString());
        }
        catch (Exception e) {
            this.logger.error("SQL error", (Throwable)e);
            return null;
        }
    }

    @Override
    public User getUserByLogin(String login) {
        try {
            return this.queryUser(this.queryByLoginSQL, login);
        }
        catch (Exception e) {
            this.logger.error("SQL error", (Throwable)e);
            return null;
        }
    }

    @Override
    public UserSession getUserSessionByOAuthAccessToken(String accessToken) throws AuthCoreProvider.OAuthAccessTokenExpired {
        try {
            LegacySessionHelper.JwtTokenInfo info = LegacySessionHelper.getJwtInfoFromAccessToken(accessToken, this.server.keyAgreementManager.ecdsaPublicKey);
            SQLUser user = (SQLUser)this.getUserByUUID(info.uuid());
            if (user == null) {
                return null;
            }
            return this.createSession(user);
        }
        catch (ExpiredJwtException e) {
            throw new AuthCoreProvider.OAuthAccessTokenExpired();
        }
        catch (JwtException e) {
            return null;
        }
    }

    @Override
    public AuthManager.AuthReport refreshAccessToken(String refreshToken, AuthResponse.AuthContext context) {
        String[] parts = refreshToken.split("\\.");
        if (parts.length != 2) {
            return null;
        }
        String username = parts[0];
        String token = parts[1];
        SQLUser user = (SQLUser)this.getUserByUsername(username);
        if (user == null || user.password == null) {
            return null;
        }
        String realToken = LegacySessionHelper.makeRefreshTokenFromPassword(username, user.password, this.server.keyAgreementManager.legacySalt);
        if (!token.equals(realToken)) {
            return null;
        }
        String accessToken = LegacySessionHelper.makeAccessJwtTokenFromString(user, LocalDateTime.now(Clock.systemUTC()).plusSeconds(this.expireSeconds), this.server.keyAgreementManager.ecdsaPrivateKey);
        return new AuthManager.AuthReport(null, accessToken, refreshToken, TimeUnit.SECONDS.toMillis(this.expireSeconds), this.createSession(user));
    }

    @Override
    public AuthManager.AuthReport authorize(String login, AuthResponse.AuthContext context, AuthRequest.AuthPasswordInterface password, boolean minecraftAccess) throws IOException {
        SQLUser user = (SQLUser)this.getUserByLogin(login);
        if (user == null) {
            throw AuthException.userNotFound();
        }
        AuthPlainPassword plainPassword = (AuthPlainPassword)password;
        if (plainPassword == null) {
            throw AuthException.wrongPassword();
        }
        if (!this.passwordVerifier.check(user.password, plainPassword.password)) {
            throw AuthException.wrongPassword();
        }
        SQLUserSession session = this.createSession(user);
        String accessToken = LegacySessionHelper.makeAccessJwtTokenFromString(user, LocalDateTime.now(Clock.systemUTC()).plusSeconds(this.expireSeconds), this.server.keyAgreementManager.ecdsaPrivateKey);
        String refreshToken = user.username.concat(".").concat(LegacySessionHelper.makeRefreshTokenFromPassword(user.username, user.password, this.server.keyAgreementManager.legacySalt));
        if (minecraftAccess) {
            String minecraftAccessToken = SecurityHelper.randomStringToken();
            this.updateAuth(user, minecraftAccessToken);
            return AuthManager.AuthReport.ofOAuthWithMinecraft(minecraftAccessToken, accessToken, refreshToken, TimeUnit.SECONDS.toMillis(this.expireSeconds), session);
        }
        return AuthManager.AuthReport.ofOAuth(accessToken, refreshToken, TimeUnit.SECONDS.toMillis(this.expireSeconds), session);
    }

    @Override
    public AuthManager.AuthReport sudo(User user, boolean shadow) throws IOException {
        SQLUser sqlUser = (SQLUser)user;
        SQLUserSession session = this.createSession(sqlUser);
        String accessToken = LegacySessionHelper.makeAccessJwtTokenFromString(sqlUser, LocalDateTime.now(Clock.systemUTC()).plusSeconds(this.expireSeconds), this.server.keyAgreementManager.ecdsaPrivateKey);
        String refreshToken = sqlUser.username.concat(".").concat(LegacySessionHelper.makeRefreshTokenFromPassword(sqlUser.username, sqlUser.password, this.server.keyAgreementManager.legacySalt));
        String minecraftAccessToken = SecurityHelper.randomStringToken();
        this.updateAuth(user, minecraftAccessToken);
        return AuthManager.AuthReport.ofOAuthWithMinecraft(minecraftAccessToken, accessToken, refreshToken, TimeUnit.SECONDS.toMillis(this.expireSeconds), session);
    }

    @Override
    public User checkServer(Client client, String username, String serverID) throws IOException {
        SQLUser user = (SQLUser)this.getUserByUsername(username);
        if (user == null) {
            return null;
        }
        if (user.getUsername().equals(username) && user.getServerId().equals(serverID)) {
            return user;
        }
        return null;
    }

    @Override
    public boolean joinServer(Client client, String username, UUID uuid, String accessToken, String serverID) throws IOException {
        SQLUser user = (SQLUser)client.getUser();
        if (user == null) {
            return false;
        }
        return (uuid == null ? user.getUsername().equals(username) : user.getUUID().equals(uuid)) && user.getAccessToken().equals(accessToken) && this.updateServerID(user, serverID);
    }

    @Override
    public void init(LaunchServer server, AuthProviderPair pair) {
        super.init(server, pair);
        if (this.getSQLConfig() == null) {
            this.logger.error("SQLHolder cannot be null");
        }
        if (this.uuidColumn == null) {
            this.logger.error("uuidColumn cannot be null");
        }
        if (this.usernameColumn == null) {
            this.logger.error("usernameColumn cannot be null");
        }
        if (this.accessTokenColumn == null) {
            this.logger.error("accessTokenColumn cannot be null");
        }
        if (this.serverIDColumn == null) {
            this.logger.error("serverIDColumn cannot be null");
        }
        if (this.table == null) {
            this.logger.error("table cannot be null");
        }
        String userInfoCols = this.makeUserCols();
        this.queryByUUIDSQL = this.customQueryByUUIDSQL != null ? this.customQueryByUUIDSQL : "SELECT %s FROM %s WHERE %s=? LIMIT 1".formatted(userInfoCols, this.table, this.uuidColumn);
        this.queryByUsernameSQL = this.customQueryByUsernameSQL != null ? this.customQueryByUsernameSQL : "SELECT %s FROM %s WHERE %s=? LIMIT 1".formatted(userInfoCols, this.table, this.usernameColumn);
        this.queryByLoginSQL = this.customQueryByLoginSQL != null ? this.customQueryByLoginSQL : this.queryByUsernameSQL;
        this.updateAuthSQL = this.customUpdateAuthSQL != null ? this.customUpdateAuthSQL : "UPDATE %s SET %s=?, %s=NULL WHERE %s=?".formatted(this.table, this.accessTokenColumn, this.serverIDColumn, this.uuidColumn);
        String string = this.updateServerIDSQL = this.customUpdateServerIdSQL != null ? this.customUpdateServerIdSQL : "UPDATE %s SET %s=? WHERE %s=?".formatted(this.table, this.serverIDColumn, this.uuidColumn);
        if (this.isEnabledPermissions()) {
            if (this.isEnabledRoles()) {
                this.queryPermissionsByUUIDSQL = this.customQueryPermissionsByUUIDSQL != null ? this.customQueryPermissionsByUUIDSQL : "WITH RECURSIVE req AS (\nSELECT p." + this.permissionsPermissionColumn + " FROM " + this.permissionsTable + " p WHERE p." + this.permissionsUUIDColumn + " = ?\nUNION ALL\nSELECT p." + this.permissionsPermissionColumn + " FROM " + this.permissionsTable + " p\nINNER JOIN " + this.rolesTable + " r ON p." + this.permissionsUUIDColumn + " = r." + this.rolesUUIDColumn + "\nINNER JOIN req ON r." + this.rolesUUIDColumn + "=substring(req." + this.permissionsPermissionColumn + " from 6) or r.name=substring(req." + this.permissionsPermissionColumn + " from 6)\n) SELECT * FROM req";
                this.queryRolesByUserUUID = this.customQueryRolesByUserUUID != null ? this.customQueryRolesByUserUUID : "SELECT r." + this.rolesNameColumn + " FROM " + this.rolesTable + " r\nINNER JOIN " + this.permissionsTable + " pr ON r." + this.rolesUUIDColumn + "=substring(pr." + this.permissionsPermissionColumn + " from 6) or r." + this.rolesNameColumn + "=substring(pr." + this.permissionsPermissionColumn + " from 6)\nWHERE pr." + this.permissionsUUIDColumn + " = ?";
            } else {
                this.queryPermissionsByUUIDSQL = this.customQueryPermissionsByUUIDSQL != null ? this.customQueryPermissionsByUUIDSQL : "SELECT (%s) FROM %s WHERE %s=?".formatted(this.permissionsPermissionColumn, this.permissionsTable, this.permissionsUUIDColumn);
            }
        }
    }

    protected String makeUserCols() {
        return "%s, %s, %s, %s, %s".formatted(this.uuidColumn, this.usernameColumn, this.accessTokenColumn, this.serverIDColumn, this.passwordColumn);
    }

    protected void updateAuth(User user, String accessToken) throws IOException {
        try (Connection c = this.getSQLConfig().getConnection();){
            SQLUser SQLUser2 = (SQLUser)user;
            SQLUser2.accessToken = accessToken;
            PreparedStatement s = c.prepareStatement(this.updateAuthSQL);
            s.setString(1, accessToken);
            s.setString(2, user.getUUID().toString());
            s.setQueryTimeout(MySQLSourceConfig.TIMEOUT);
            s.executeUpdate();
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    protected boolean updateServerID(User user, String serverID) throws IOException {
        boolean bl;
        block8: {
            Connection c = this.getSQLConfig().getConnection();
            try {
                SQLUser SQLUser2 = (SQLUser)user;
                SQLUser2.serverId = serverID;
                PreparedStatement s = c.prepareStatement(this.updateServerIDSQL);
                s.setString(1, serverID);
                s.setString(2, user.getUUID().toString());
                s.setQueryTimeout(MySQLSourceConfig.TIMEOUT);
                boolean bl2 = bl = s.executeUpdate() > 0;
                if (c == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (c != null) {
                        try {
                            c.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new IOException(e);
                }
            }
            c.close();
        }
        return bl;
    }

    @Override
    public void close() {
        this.getSQLConfig().close();
    }

    protected SQLUser constructUser(ResultSet set) throws SQLException {
        return set.next() ? new SQLUser(UUID.fromString(set.getString(this.uuidColumn)), set.getString(this.usernameColumn), set.getString(this.accessTokenColumn), set.getString(this.serverIDColumn), set.getString(this.passwordColumn)) : null;
    }

    public ClientPermissions requestPermissions(String uuid) throws SQLException {
        return new ClientPermissions(this.isEnabledRoles() ? this.queryRolesNames(this.queryRolesByUserUUID, uuid) : new ArrayList(), this.isEnabledPermissions() ? this.queryPermissions(this.queryPermissionsByUUIDSQL, uuid) : new ArrayList());
    }

    private SQLUser queryUser(String sql, String value) throws SQLException {
        SQLUser user;
        try (Connection c = this.getSQLConfig().getConnection();){
            PreparedStatement s = c.prepareStatement(sql);
            s.setString(1, value);
            s.setQueryTimeout(MySQLSourceConfig.TIMEOUT);
            try (ResultSet set = s.executeQuery();){
                user = this.constructUser(set);
            }
        }
        if (user != null) {
            user.permissions = this.requestPermissions(user.uuid.toString());
        }
        return user;
    }

    private List<String> queryPermissions(String sql, String value) throws SQLException {
        try (Connection c = this.getSQLConfig().getConnection();){
            PreparedStatement s = c.prepareStatement(sql);
            s.setString(1, value);
            s.setQueryTimeout(MySQLSourceConfig.TIMEOUT);
            ResultSet set = s.executeQuery();
            ArrayList<String> perms = new ArrayList<String>();
            while (set.next()) {
                perms.add(set.getString(this.permissionsPermissionColumn));
            }
            ArrayList<String> arrayList = perms;
            return arrayList;
        }
    }

    protected SQLUserSession createSession(SQLUser user) {
        return new SQLUserSession(user);
    }

    public boolean isEnabledPermissions() {
        return this.permissionsPermissionColumn != null;
    }

    public boolean isEnabledRoles() {
        return this.rolesNameColumn != null;
    }

    private List<String> queryRolesNames(String sql, String value) throws SQLException {
        try (Connection c = this.getSQLConfig().getConnection();){
            PreparedStatement s = c.prepareStatement(sql);
            s.setString(1, value);
            s.setQueryTimeout(MySQLSourceConfig.TIMEOUT);
            ResultSet set = s.executeQuery();
            ArrayList<String> perms = new ArrayList<String>();
            while (set.next()) {
                perms.add(set.getString(this.rolesNameColumn));
            }
            ArrayList<String> arrayList = perms;
            return arrayList;
        }
    }

    public static class SQLUser
    implements User {
        protected final UUID uuid;
        protected final String username;
        protected String accessToken;
        protected String serverId;
        protected final String password;
        protected ClientPermissions permissions;

        public SQLUser(UUID uuid, String username, String accessToken, String serverId, String password) {
            this.uuid = uuid;
            this.username = username;
            this.accessToken = accessToken;
            this.serverId = serverId;
            this.password = password;
        }

        @Override
        public String getUsername() {
            return this.username;
        }

        @Override
        public UUID getUUID() {
            return this.uuid;
        }

        public String getServerId() {
            return this.serverId;
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        @Override
        public ClientPermissions getPermissions() {
            return this.permissions;
        }

        public String toString() {
            return "SQLUser{uuid=" + String.valueOf(this.uuid) + ", username='" + this.username + "', permissions=" + String.valueOf(this.permissions) + "}";
        }
    }

    public static class SQLUserSession
    implements UserSession {
        private final SQLUser user;
        private final String id;

        public SQLUserSession(SQLUser user) {
            this.user = user;
            this.id = user.username;
        }

        @Override
        public String getID() {
            return this.id;
        }

        @Override
        public User getUser() {
            return this.user;
        }

        @Override
        public String getMinecraftAccessToken() {
            return this.user.getAccessToken();
        }

        @Override
        public long getExpireIn() {
            return 0L;
        }
    }
}

