/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.profiles;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.profiles.LocalProfileProvider;
import pro.gravit.launchserver.auth.protect.ProtectHandler;
import pro.gravit.launchserver.auth.protect.interfaces.ProfilesProtectHandler;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.utils.ProviderMap;

public abstract class ProfileProvider {
    public static final ProviderMap<ProfileProvider> providers = new ProviderMap("ProfileProvider");
    private static boolean registredProviders = false;
    protected transient LaunchServer server;

    public static void registerProviders() {
        if (!registredProviders) {
            providers.register("local", LocalProfileProvider.class);
            registredProviders = true;
        }
    }

    public void init(LaunchServer server) {
        this.server = server;
    }

    public abstract void sync() throws IOException;

    public abstract Set<ClientProfile> getProfiles();

    public abstract void addProfile(ClientProfile var1) throws IOException;

    public abstract void deleteProfile(ClientProfile var1) throws IOException;

    public void close() {
    }

    public ClientProfile getProfile(UUID uuid) {
        for (ClientProfile e : this.getProfiles()) {
            if (!e.getUUID().equals(uuid)) continue;
            return e;
        }
        return null;
    }

    public ClientProfile getProfile(String title) {
        for (ClientProfile e : this.getProfiles()) {
            if (!e.getTitle().equals(title)) continue;
            return e;
        }
        return null;
    }

    public List<ClientProfile> getProfiles(Client client) {
        List<ClientProfile> profileList;
        Set<ClientProfile> serverProfiles = this.getProfiles();
        ProtectHandler protectHandler = this.server.config.protectHandler;
        if (protectHandler instanceof ProfilesProtectHandler) {
            ProfilesProtectHandler protectHandler2 = (ProfilesProtectHandler)((Object)protectHandler);
            profileList = new ArrayList<ClientProfile>(4);
            for (ClientProfile profile : serverProfiles) {
                if (!protectHandler2.canGetProfile(profile, client)) continue;
                profileList.add(profile);
            }
        } else {
            profileList = List.copyOf(serverProfiles);
        }
        return profileList;
    }
}

