/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.updates;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.core.hasher.HashedDir;
import pro.gravit.launcher.core.serialize.HInput;
import pro.gravit.launcher.core.serialize.HOutput;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.updates.UpdatesProvider;
import pro.gravit.launchserver.modules.events.LaunchServerUpdatesSyncEvent;
import pro.gravit.utils.helper.IOHelper;

public class LocalUpdatesProvider
extends UpdatesProvider {
    private final transient Logger logger = LogManager.getLogger();
    public String cacheFile = ".updates-cache";
    public String updatesDir = "updates";
    public boolean cacheUpdates = true;
    private volatile transient Map<String, HashedDir> updatesDirMap;

    private void writeCache(Path file) throws IOException {
        try (HOutput output = new HOutput(IOHelper.newOutput((Path)file));){
            output.writeLength(this.updatesDirMap.size(), 0);
            for (Map.Entry<String, HashedDir> entry : this.updatesDirMap.entrySet()) {
                output.writeString(entry.getKey(), 0);
                entry.getValue().write(output);
            }
        }
        this.logger.debug("Saved {} updates to cache", (Object)this.updatesDirMap.size());
    }

    private void readCache(Path file) throws IOException {
        HashMap<String, HashedDir> updatesDirMap = new HashMap<String, HashedDir>(16);
        try (HInput input = new HInput(IOHelper.newInput((Path)file));){
            int size = input.readLength(0);
            for (int i = 0; i < size; ++i) {
                String name = input.readString(0);
                HashedDir dir = new HashedDir(input);
                updatesDirMap.put(name, dir);
            }
        }
        this.logger.debug("Found {} updates from cache", (Object)updatesDirMap.size());
        this.updatesDirMap = Collections.unmodifiableMap(updatesDirMap);
    }

    public void readUpdatesFromCache() throws IOException {
        this.readCache(Path.of(this.cacheFile, new String[0]));
    }

    public void readUpdatesDir() throws IOException {
        Path cacheFilePath = Path.of(this.cacheFile, new String[0]);
        if (this.cacheUpdates && Files.exists(cacheFilePath, new LinkOption[0])) {
            try {
                this.readCache(cacheFilePath);
                return;
            }
            catch (Throwable e) {
                this.logger.error("Read updates cache failed", e);
            }
        }
        this.sync(null);
    }

    @Override
    public void init(LaunchServer server) {
        super.init(server);
        try {
            if (!IOHelper.isDir((Path)Path.of(this.updatesDir, new String[0]))) {
                Files.createDirectory(Path.of(this.updatesDir, new String[0]), new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            this.logger.error("Updates not synced", (Throwable)e);
        }
    }

    @Override
    public void syncInitially() throws IOException {
        this.readUpdatesDir();
    }

    @Override
    public void sync(Collection<String> dirs) throws IOException {
        this.logger.info("Syncing updates dir");
        HashMap<String, HashedDir> newUpdatesDirMap = new HashMap<String, HashedDir>(16);
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(Path.of(this.updatesDir, new String[0]));){
            for (Path updateDir : dirStream) {
                HashedDir hdir;
                if (Files.isHidden(updateDir)) continue;
                String name = IOHelper.getFileName((Path)updateDir);
                if (!IOHelper.isDir((Path)updateDir)) {
                    if (IOHelper.isFile((Path)updateDir) || !Stream.of(".jar", ".exe", ".hash").noneMatch(e -> updateDir.toString().endsWith((String)e))) continue;
                    this.logger.warn("Not update dir: '{}'", (Object)name);
                    continue;
                }
                if (dirs != null && !dirs.contains(name) && (hdir = this.updatesDirMap.get(name)) != null) {
                    newUpdatesDirMap.put(name, hdir);
                    continue;
                }
                this.logger.info("Syncing '{}' update dir", (Object)name);
                HashedDir updateHDir = new HashedDir(updateDir, null, true, true);
                newUpdatesDirMap.put(name, updateHDir);
            }
        }
        this.updatesDirMap = Collections.unmodifiableMap(newUpdatesDirMap);
        if (this.cacheUpdates) {
            try {
                this.writeCache(Path.of(this.cacheFile, new String[0]));
            }
            catch (Throwable e2) {
                this.logger.error("Write updates cache failed", e2);
            }
        }
        this.server.modulesManager.invokeEvent(new LaunchServerUpdatesSyncEvent(this.server));
    }

    @Override
    public HashedDir getUpdatesDir(String updateName) {
        return this.updatesDirMap.get(updateName);
    }

    private Path resolveUpdateName(String updateName) {
        if (updateName == null) {
            return Path.of(this.updatesDir, new String[0]);
        }
        return Path.of(this.updatesDir, new String[0]).resolve(updateName);
    }

    @Override
    public void upload(String updateName, Map<String, Path> files, boolean deleteAfterUpload) throws IOException {
        Path path = this.resolveUpdateName(updateName);
        for (Map.Entry<String, Path> e : files.entrySet()) {
            Path target = path.resolve(e.getKey());
            Path source = e.getValue();
            IOHelper.createParentDirs((Path)target);
            if (deleteAfterUpload) {
                Files.move(source, target, StandardCopyOption.REPLACE_EXISTING);
                continue;
            }
            Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    @Override
    public Map<String, Path> download(String updateName, List<String> files) {
        Path path = this.resolveUpdateName(updateName);
        HashMap<String, Path> map = new HashMap<String, Path>();
        for (String e : files) {
            map.put(e, path.resolve(e));
        }
        return map;
    }

    @Override
    public void delete(String updateName, List<String> files) throws IOException {
        Path path = this.resolveUpdateName(updateName);
        for (String e : files) {
            Path target = path.resolve(e);
            Files.delete(target);
        }
    }

    @Override
    public void delete(String updateName) throws IOException {
        Path path = this.resolveUpdateName(updateName);
        IOHelper.deleteDir((Path)path, (boolean)true);
    }

    @Override
    public void create(String updateName) throws IOException {
        Path path = this.resolveUpdateName(updateName);
        Files.createDirectories(path, new FileAttribute[0]);
    }
}

