/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.binary;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.binary.BinaryPipeline;
import pro.gravit.launchserver.binary.tasks.LauncherBuildTask;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.SecurityHelper;

public abstract class LauncherBinary
extends BinaryPipeline {
    public final LaunchServer server;
    public final Path syncBinaryFile;
    private volatile byte[] digest;

    protected LauncherBinary(LaunchServer server, Path binaryFile, String nameFormat) {
        super(server.tmpDir.resolve("build"), nameFormat);
        this.server = server;
        this.syncBinaryFile = binaryFile;
    }

    public static Path resolve(LaunchServer server, String ext) {
        return Path.of(server.config.binaryName + ext, new String[0]);
    }

    public void build() throws IOException {
        long time_start;
        this.logger.info("Building launcher binary file");
        Path thisPath = null;
        long time_this = time_start = System.currentTimeMillis();
        for (LauncherBuildTask task : this.tasks) {
            this.logger.info("Task {}", (Object)task.getName());
            Path oldPath = thisPath;
            thisPath = task.process(oldPath);
            long time_task_end = System.currentTimeMillis();
            long time_task = time_task_end - time_this;
            time_this = time_task_end;
            this.logger.info("Task {} processed from {} millis", (Object)task.getName(), (Object)time_task);
        }
        long time_end = System.currentTimeMillis();
        this.server.config.updatesProvider.upload(null, Map.of(this.syncBinaryFile.toString(), thisPath), true);
        IOHelper.deleteDir((Path)this.buildDir, (boolean)false);
        this.logger.info("Build successful from {} millis", (Object)(time_end - time_start));
    }

    public final boolean exists() {
        return this.syncBinaryFile != null && IOHelper.isFile((Path)this.syncBinaryFile);
    }

    public final byte[] getDigest() {
        return this.digest;
    }

    public void init() {
    }

    public final boolean sync() throws IOException {
        try {
            String target = this.syncBinaryFile.toString();
            Path path = this.server.config.updatesProvider.download(null, List.of(target)).get(target);
            this.digest = SecurityHelper.digest((SecurityHelper.DigestAlgorithm)SecurityHelper.DigestAlgorithm.SHA512, (byte[])IOHelper.read((Path)path));
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }
}

