/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.command.profiles;

import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.command.Command;

public class SaveProfilesCommand
extends Command {
    private final transient Logger logger = LogManager.getLogger();

    public SaveProfilesCommand(LaunchServer server) {
        super(server);
    }

    public String getArgsDescription() {
        return "[profile names...]";
    }

    public String getUsageDescription() {
        return "load and save profile";
    }

    public void invoke(String ... args) throws Exception {
        this.verifyArgs(args, 1);
        if (args.length > 0) {
            for (String profileName : args) {
                ClientProfile profile;
                try {
                    UUID uuid = UUID.fromString(profileName);
                    profile = this.server.config.profileProvider.getProfile(uuid);
                }
                catch (IllegalArgumentException ex) {
                    profile = this.server.config.profileProvider.getProfile(profileName);
                }
                this.server.config.profileProvider.addProfile(profile);
            }
            this.server.syncProfilesDir();
        }
    }
}

