/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.socket.handlers;

import java.net.InetSocketAddress;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.config.LaunchServerConfig;
import pro.gravit.launchserver.modules.events.LaunchServerNettyFullInitEvent;
import pro.gravit.launchserver.socket.LauncherNettyServer;

public final class NettyServerSocketHandler
implements Runnable,
AutoCloseable {
    private final transient LaunchServer server;
    private final transient Logger logger = LogManager.getLogger();
    public LauncherNettyServer nettyServer;
    private SSLServerSocketFactory ssf;

    public NettyServerSocketHandler(LaunchServer server) {
        this.server = server;
    }

    @Override
    public void close() {
        if (this.nettyServer == null) {
            return;
        }
        this.nettyServer.close();
        this.nettyServer.service.channels.close();
    }

    @Override
    public void run() {
        this.logger.info("Starting netty server socket thread");
        this.nettyServer = new LauncherNettyServer(this.server);
        for (LaunchServerConfig.NettyBindAddress address : this.server.config.netty.binds) {
            this.nettyServer.bind(new InetSocketAddress(address.address, address.port));
        }
        this.server.modulesManager.invokeEvent(new LaunchServerNettyFullInitEvent(this.server));
    }
}

