/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.core.openid;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import java.io.IOException;
import java.security.Key;
import java.security.PublicKey;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import pro.gravit.launcher.base.ClientPermissions;
import pro.gravit.launcher.base.events.request.GetAvailabilityAuthRequestEvent;
import pro.gravit.launcher.base.request.auth.AuthRequest;
import pro.gravit.launcher.base.request.auth.password.AuthCodePassword;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.AuthException;
import pro.gravit.launchserver.auth.AuthProviderPair;
import pro.gravit.launchserver.auth.HikariSQLSourceConfig;
import pro.gravit.launchserver.auth.core.AuthCoreProvider;
import pro.gravit.launchserver.auth.core.User;
import pro.gravit.launchserver.auth.core.UserSession;
import pro.gravit.launchserver.auth.core.openid.OpenIDAuthenticator;
import pro.gravit.launchserver.auth.core.openid.OpenIDConfig;
import pro.gravit.launchserver.auth.core.openid.SQLServerSessionStore;
import pro.gravit.launchserver.auth.core.openid.SQLUserStore;
import pro.gravit.launchserver.auth.core.openid.TokenResponse;
import pro.gravit.launchserver.auth.core.openid.UserEntity;
import pro.gravit.launchserver.manangers.AuthManager;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.response.auth.AuthResponse;
import pro.gravit.utils.helper.LogHelper;

public class OpenIDAuthCoreProvider
extends AuthCoreProvider {
    private transient SQLUserStore sqlUserStore;
    private transient SQLServerSessionStore sqlSessionStore;
    private transient OpenIDAuthenticator openIDAuthenticator;
    private OpenIDConfig openIDConfig;
    private HikariSQLSourceConfig sqlSourceConfig;

    @Override
    public List<GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails> getDetails(Client client) {
        return this.openIDAuthenticator.getDetails();
    }

    @Override
    public User getUserByUsername(String username) {
        return this.sqlUserStore.getByUsername(username);
    }

    @Override
    public User getUserByUUID(UUID uuid) {
        return this.sqlUserStore.getUserByUUID(uuid);
    }

    @Override
    public UserSession getUserSessionByOAuthAccessToken(String accessToken) throws AuthCoreProvider.OAuthAccessTokenExpired {
        return this.openIDAuthenticator.getUserSessionByOAuthAccessToken(accessToken);
    }

    @Override
    public AuthManager.AuthReport refreshAccessToken(String oldRefreshToken, AuthResponse.AuthContext context) {
        UserSession session;
        TokenResponse tokens = this.openIDAuthenticator.refreshAccessToken(oldRefreshToken);
        String accessToken = tokens.accessToken();
        String refreshToken = tokens.refreshToken();
        long expiresIn = TimeUnit.SECONDS.toMillis(tokens.accessTokenExpiresIn());
        try {
            session = this.openIDAuthenticator.getUserSessionByOAuthAccessToken(accessToken);
        }
        catch (AuthCoreProvider.OAuthAccessTokenExpired e) {
            throw new RuntimeException("invalid token", e);
        }
        return AuthManager.AuthReport.ofOAuth(accessToken, refreshToken, expiresIn, session);
    }

    @Override
    public AuthManager.AuthReport authorize(String login, AuthResponse.AuthContext context, AuthRequest.AuthPasswordInterface password, boolean minecraftAccess) throws IOException {
        UserSession session;
        if (password == null) {
            throw AuthException.wrongPassword();
        }
        AuthCodePassword authCodePassword = (AuthCodePassword)password;
        TokenResponse tokens = this.openIDAuthenticator.authorize(authCodePassword);
        String accessToken = tokens.accessToken();
        String refreshToken = tokens.refreshToken();
        User user = this.openIDAuthenticator.createUserFromToken(accessToken);
        long expiresIn = TimeUnit.SECONDS.toMillis(tokens.accessTokenExpiresIn());
        this.sqlUserStore.createOrUpdateUser(user);
        try {
            session = this.openIDAuthenticator.getUserSessionByOAuthAccessToken(accessToken);
        }
        catch (AuthCoreProvider.OAuthAccessTokenExpired e) {
            throw new AuthException("invalid token", e);
        }
        if (minecraftAccess) {
            String minecraftToken = this.generateMinecraftToken(user);
            return AuthManager.AuthReport.ofOAuthWithMinecraft(minecraftToken, accessToken, refreshToken, expiresIn, session);
        }
        return AuthManager.AuthReport.ofOAuth(accessToken, refreshToken, expiresIn, session);
    }

    private String generateMinecraftToken(User user) {
        return Jwts.builder().issuer("LaunchServer").subject(user.getUUID().toString()).claim("preferred_username", (Object)user.getUsername()).expiration(Date.from(Instant.now().plus(24L, ChronoUnit.HOURS))).signWith((Key)this.server.keyAgreementManager.ecdsaPrivateKey).compact();
    }

    private User createUserFromMinecraftToken(String accessToken) throws AuthException {
        try {
            JwtParser parser = Jwts.parser().requireIssuer("LaunchServer").verifyWith((PublicKey)this.server.keyAgreementManager.ecdsaPublicKey).build();
            Jws claims = parser.parseSignedClaims((CharSequence)accessToken);
            String username = (String)((Claims)claims.getPayload()).get("preferred_username", String.class);
            UUID uuid = UUID.fromString(((Claims)claims.getPayload()).getSubject());
            return new UserEntity(username, uuid, new ClientPermissions());
        }
        catch (JwtException e) {
            throw new AuthException("Bad minecraft token", e);
        }
    }

    @Override
    public void init(LaunchServer server, AuthProviderPair pair) {
        super.init(server, pair);
        this.sqlSourceConfig.init();
        this.sqlUserStore = new SQLUserStore(this.sqlSourceConfig);
        this.sqlUserStore.init();
        this.sqlSessionStore = new SQLServerSessionStore(this.sqlSourceConfig);
        this.sqlSessionStore.init();
        this.openIDAuthenticator = new OpenIDAuthenticator(this.openIDConfig);
    }

    @Override
    public User checkServer(Client client, String username, String serverID) throws IOException {
        String savedServerId = this.sqlSessionStore.getServerIdByUsername(username);
        if (!serverID.equals(savedServerId)) {
            return null;
        }
        return this.sqlUserStore.getByUsername(username);
    }

    @Override
    public boolean joinServer(Client client, String username, UUID uuid, String accessToken, String serverID) throws IOException {
        User user;
        try {
            user = this.createUserFromMinecraftToken(accessToken);
        }
        catch (AuthException e) {
            LogHelper.error((Throwable)e);
            return false;
        }
        if (!user.getUUID().equals(uuid)) {
            return false;
        }
        this.sqlUserStore.createOrUpdateUser(user);
        return this.sqlSessionStore.joinServer(user.getUUID(), user.getUsername(), serverID);
    }

    @Override
    public void close() {
        this.sqlSourceConfig.close();
    }
}

