/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.profiles;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launchserver.auth.profiles.ProfileProvider;
import pro.gravit.utils.helper.IOHelper;

public class LocalProfileProvider
extends ProfileProvider {
    public String profilesDir = "profiles";
    private volatile transient Map<Path, ClientProfile> profilesMap;
    private volatile transient Set<ClientProfile> profilesList;

    @Override
    public void sync() throws IOException {
        Path profilesDirPath = Path.of(this.profilesDir, new String[0]);
        if (!IOHelper.isDir((Path)profilesDirPath)) {
            Files.createDirectory(profilesDirPath, new FileAttribute[0]);
        }
        HashMap<Path, ClientProfile> newProfiles = new HashMap<Path, ClientProfile>();
        IOHelper.walk((Path)profilesDirPath, (FileVisitor)new ProfilesFileVisitor(newProfiles), (boolean)false);
        HashSet newProfilesList = new HashSet(newProfiles.values());
        this.profilesMap = newProfiles;
        this.profilesList = newProfilesList;
    }

    @Override
    public Set<ClientProfile> getProfiles() {
        return this.profilesList;
    }

    @Override
    public void addProfile(ClientProfile profile) throws IOException {
        ClientProfile oldProfile;
        Path profilesDirPath = Path.of(this.profilesDir, new String[0]);
        Path target = null;
        for (Map.Entry<Path, ClientProfile> e : this.profilesMap.entrySet()) {
            if (!e.getValue().getUUID().equals(profile.getUUID())) continue;
            target = e.getKey();
        }
        if (target == null && (oldProfile = this.profilesMap.get(target = profilesDirPath.resolve(profile.getTitle() + ".json"))) != null && !oldProfile.getUUID().equals(profile.getUUID())) {
            throw new FileAlreadyExistsException(target.toString());
        }
        try (BufferedWriter writer = IOHelper.newWriter(target);){
            Launcher.gsonManager.configGson.toJson((Object)profile, (Appendable)writer);
        }
        this.addProfile(target, profile);
    }

    @Override
    public void deleteProfile(ClientProfile profile) throws IOException {
        for (Map.Entry<Path, ClientProfile> e : this.profilesMap.entrySet()) {
            if (!e.getValue().getUUID().equals(profile.getUUID())) continue;
            Files.deleteIfExists(e.getKey());
            this.profilesMap.remove(e.getKey());
            this.profilesList.remove(e.getValue());
            break;
        }
    }

    private void addProfile(Path path, ClientProfile profile) {
        for (Map.Entry<Path, ClientProfile> e : this.profilesMap.entrySet()) {
            if (!e.getValue().getUUID().equals(profile.getUUID())) continue;
            this.profilesMap.remove(e.getKey());
            this.profilesList.remove(e.getValue());
            break;
        }
        this.profilesMap.put(path, profile);
        this.profilesList.add(profile);
    }

    private static final class ProfilesFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Map<Path, ClientProfile> result;
        private final Logger logger = LogManager.getLogger();

        private ProfilesFileVisitor(Map<Path, ClientProfile> result) {
            this.result = result;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            ClientProfile profile;
            this.logger.info("Syncing '{}' profile", (Object)IOHelper.getFileName((Path)file));
            try (BufferedReader reader = IOHelper.newReader((Path)file);){
                profile = (ClientProfile)Launcher.gsonManager.gson.fromJson((Reader)reader, ClientProfile.class);
            }
            profile.verify();
            this.result.put(file.toAbsolutePath(), profile);
            return super.visitFile(file, attrs);
        }
    }
}

