/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.texture;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.base.profiles.Texture;
import pro.gravit.launchserver.HttpRequester;
import pro.gravit.launchserver.auth.texture.RequestTextureProvider;
import pro.gravit.launchserver.auth.texture.TextureProvider;
import pro.gravit.utils.helper.SecurityHelper;

public class JsonTextureProvider
extends TextureProvider {
    private static final Type MAP_TYPE = new TypeToken<Map<String, JsonTexture>>(){}.getType();
    private final transient Logger logger = LogManager.getLogger();
    private final transient HttpRequester requester = new HttpRequester();
    public String url;
    public String bearerToken;

    @Override
    public void close() {
    }

    @Override
    public Texture getCloakTexture(UUID uuid, String username, String client) {
        this.logger.warn("Ineffective get cloak texture for {}", (Object)username);
        return this.getAssets(uuid, username, client).get("CAPE");
    }

    @Override
    public Texture getSkinTexture(UUID uuid, String username, String client) {
        this.logger.warn("Ineffective get skin texture for {}", (Object)username);
        return this.getAssets(uuid, username, client).get("SKIN");
    }

    @Override
    public Map<String, Texture> getAssets(UUID uuid, String username, String client) {
        try {
            Map map = (Map)this.requester.send(this.requester.get(RequestTextureProvider.getTextureURL(this.url, uuid, username, client), this.bearerToken), MAP_TYPE).getOrThrow();
            return JsonTexture.convertMap(map);
        }
        catch (IOException e) {
            this.logger.error("JsonTextureProvider", (Throwable)e);
            return new HashMap<String, Texture>();
        }
    }

    public record JsonTexture(String url, String digest, Map<String, String> metadata) {
        public Texture toTexture() {
            return new Texture(this.url, this.digest == null ? null : SecurityHelper.fromHex((String)this.digest), this.metadata);
        }

        public static Map<String, Texture> convertMap(Map<String, JsonTexture> map) {
            if (map == null) {
                return new HashMap<String, Texture>();
            }
            HashMap<String, Texture> res = new HashMap<String, Texture>();
            for (Map.Entry<String, JsonTexture> e : map.entrySet()) {
                res.put(e.getKey(), e.getValue().toTexture());
            }
            return res;
        }
    }
}

