/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.command.profiles;

import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.command.Command;
import pro.gravit.launchserver.command.profiles.ListProfilesCommand;

public class DeleteProfileCommand
extends Command {
    private final transient Logger logger = LogManager.getLogger(ListProfilesCommand.class);

    public DeleteProfileCommand(LaunchServer server) {
        super(server);
    }

    public String getArgsDescription() {
        return "[uuid/title]";
    }

    public String getUsageDescription() {
        return "permanently delete profile";
    }

    public void invoke(String ... args) throws Exception {
        ClientProfile profile;
        this.verifyArgs(args, 1);
        try {
            UUID uuid = UUID.fromString(args[0]);
            profile = this.server.config.profileProvider.getProfile(uuid);
        }
        catch (IllegalArgumentException ex) {
            profile = this.server.config.profileProvider.getProfile(args[0]);
        }
        if (profile == null) {
            this.logger.error("Profile {} not found", (Object)args[0]);
            return;
        }
        this.logger.warn("THIS ACTION DELETE PROFILE AND ALL FILES IN {}", (Object)profile.getDir());
        if (!this.showApplyDialog("Continue?")) {
            return;
        }
        this.logger.info("Delete {} ({})", (Object)profile.getTitle(), (Object)profile.getUUID());
        this.server.config.profileProvider.deleteProfile(profile);
        this.logger.info("Delete {}", (Object)profile.getDir());
        this.server.config.updatesProvider.delete(profile.getDir());
    }
}

