/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.helper;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launcher.base.profiles.ClientProfileBuilder;
import pro.gravit.launcher.base.profiles.ClientProfileVersions;
import pro.gravit.launcher.base.profiles.optional.OptionalFile;
import pro.gravit.launcher.base.profiles.optional.actions.OptionalActionFile;
import pro.gravit.launcher.base.profiles.optional.actions.OptionalActionJvmArgs;
import pro.gravit.launcher.base.profiles.optional.triggers.OSTrigger;
import pro.gravit.utils.helper.JVMHelper;

public class MakeProfileHelper {
    public static ClientProfile makeProfile(ClientProfile.Version version, String title, MakeProfileOption ... options) {
        Optional<MakeProfileOptionLog4j> logFile;
        ClientProfileBuilder builder = new ClientProfileBuilder();
        builder.setVersion(version);
        builder.setDir(title);
        builder.setAssetDir("assets");
        builder.setAssetIndex(version.toString());
        builder.setInfo("Server description");
        builder.setTitle(title);
        builder.setUuid(UUID.randomUUID());
        builder.setMainClass(MakeProfileHelper.getMainClassByVersion(version, options));
        builder.setServers(List.of(new ClientProfile.ServerProfile(title, "localhost", 25565)));
        Optional<Lwjgl3ifyOption> lwjgl3ify = MakeProfileHelper.findOption(options, Lwjgl3ifyOption.class);
        builder.setUpdateVerify(List.of("libraries", "natives", "mods", "minecraft.jar", "forge.jar", "liteloader.jar"));
        ArrayList<String> classPath = new ArrayList<String>(5);
        if (MakeProfileHelper.findOption(options, MakeProfileOptionLaunchWrapper.class).isPresent()) {
            classPath.add("libraries/net/minecraft/launchwrapper/1.12/launchwrapper-1.12.jar");
        }
        classPath.add("libraries");
        classPath.add("minecraft.jar");
        if (version.compareTo(ClientProfileVersions.MINECRAFT_1_12_2) <= 0) {
            MakeProfileHelper.findOption(options, MakeProfileOptionForge.class).ifPresent(e -> classPath.add("forge.jar"));
            MakeProfileHelper.findOption(options, MakeProfileOptionLiteLoader.class).ifPresent(e -> classPath.add("liteloader.jar"));
        }
        builder.setClassPath(classPath);
        builder.setUpdate(List.of("servers.dat"));
        ArrayList<String> jvmArgs = new ArrayList<String>(4);
        HashSet<OptionalFile> optionals = new HashSet<OptionalFile>();
        jvmArgs.add("-XX:+DisableAttachMechanism");
        if (version.compareTo(ClientProfileVersions.MINECRAFT_1_12_2) <= 0) {
            jvmArgs.add("-Djava.security.manager=allow");
            jvmArgs.add("--add-opens");
            jvmArgs.add("java.base/jdk.internal.loader=ALL-UNNAMED");
            jvmArgs.add("--add-opens");
            jvmArgs.add("java.base/java.net=ALL-UNNAMED");
            jvmArgs.add("--add-opens");
            jvmArgs.add("java.base/java.nio=ALL-UNNAMED");
            jvmArgs.add("--add-opens");
            jvmArgs.add("java.base/java.io=ALL-UNNAMED");
            jvmArgs.add("--add-opens");
            jvmArgs.add("java.base/java.lang=ALL-UNNAMED");
            jvmArgs.add("--add-opens");
            jvmArgs.add("java.base/java.lang.reflect=ALL-UNNAMED");
            jvmArgs.add("--add-opens");
            jvmArgs.add("java.base/java.text=ALL-UNNAMED");
            jvmArgs.add("--add-opens");
            jvmArgs.add("java.base/java.util=ALL-UNNAMED");
            jvmArgs.add("--add-opens");
            jvmArgs.add("java.base/jdk.internal.reflect=ALL-UNNAMED");
            jvmArgs.add("--add-opens");
            jvmArgs.add("java.base/sun.nio.ch=ALL-UNNAMED");
            jvmArgs.add("--add-opens");
            jvmArgs.add("jdk.naming.dns/com.sun.jndi.dns=ALL-UNNAMED,java.naming");
            jvmArgs.add("--add-opens");
            jvmArgs.add("java.desktop/sun.awt=ALL-UNNAMED");
            jvmArgs.add("--add-opens");
            jvmArgs.add("java.desktop/sun.awt.image=ALL-UNNAMED");
            jvmArgs.add("--add-opens");
            jvmArgs.add("java.desktop/com.sun.imageio.plugins.png=ALL-UNNAMED");
            jvmArgs.add("--add-opens");
            jvmArgs.add("jdk.dynalink/jdk.dynalink.beans=ALL-UNNAMED");
            jvmArgs.add("--add-opens");
            jvmArgs.add("java.sql.rowset/javax.sql.rowset.serial=ALL-UNNAMED");
        } else if (version.compareTo(ClientProfileVersions.MINECRAFT_1_18) <= 0) {
            jvmArgs.add("-XX:+UseG1GC");
            jvmArgs.add("-XX:+UnlockExperimentalVMOptions");
        }
        Optional<MakeProfileOptionForge> forge = MakeProfileHelper.findOption(options, MakeProfileOptionForge.class);
        Optional<MakeProfileOptionFabric> fabric = MakeProfileHelper.findOption(options, MakeProfileOptionFabric.class);
        Optional<MakeProfilesOptionsQuilt> quilt = MakeProfileHelper.findOption(options, MakeProfilesOptionsQuilt.class);
        if (version.compareTo(ClientProfileVersions.MINECRAFT_1_12_2) > 0) {
            jvmArgs.add("-Djava.library.path=natives");
            OptionalFile optionalMacOs = new OptionalFile();
            optionalMacOs.name = "MacOSArgs";
            optionalMacOs.visible = false;
            optionalMacOs.actions = new ArrayList(1);
            optionalMacOs.actions.add(new OptionalActionJvmArgs(List.of("-XstartOnFirstThread")));
            optionalMacOs.triggersList = List.of(new OSTrigger(JVMHelper.OS.MACOSX));
            optionals.add(optionalMacOs);
        }
        if (fabric.isPresent()) {
            builder.setAltClassPath(fabric.orElseThrow().getAltClassPath());
            jvmArgs.add("-Dsodium.checks.issue2561=false");
        }
        if (quilt.isPresent()) {
            builder.setClassLoaderConfig(ClientProfile.ClassLoaderConfig.SYSTEM_ARGS);
        }
        if (MakeProfileHelper.findOption(options, MakeProfileOptionLwjgl.class).isPresent()) {
            OptionalFile optionalMac = new OptionalFile();
            optionalMac.name = "MacLwjgl";
            optionalMac.visible = false;
            optionalMac.actions = new ArrayList(1);
            optionalMac.actions.add(new OptionalActionFile(Map.of("libraries/org/lwjgl/lwjgl/3.2.1", "", "libraries/org/lwjgl/lwjgl-glfw/3.2.1", "", "libraries/org/lwjgl/lwjgl-openal/3.2.1", "", "libraries/org/lwjgl/lwjgl-stb/3.2.1", "", "libraries/org/lwjgl/lwjgl-tinyfd/3.2.1", "", "libraries/org/lwjgl/lwjgl-opengl/3.2.1", "", "libraries/org/lwjgl/lwjgl-jemalloc/3.2.1", "")));
            optionalMac.triggersList = List.of(new OSTrigger(JVMHelper.OS.MACOSX));
            optionals.add(optionalMac);
            OptionalFile optionalOther = new OptionalFile();
            optionalOther.name = "NonMacLwjgl";
            optionalOther.visible = false;
            optionalOther.actions = new ArrayList(1);
            optionalOther.actions.add(new OptionalActionFile(Map.of("libraries/org/lwjgl/lwjgl/3.2.2", "", "libraries/org/lwjgl/lwjgl-glfw/3.2.2", "", "libraries/org/lwjgl/lwjgl-openal/3.2.2", "", "libraries/org/lwjgl/lwjgl-stb/3.2.2", "", "libraries/org/lwjgl/lwjgl-tinyfd/3.2.2", "", "libraries/org/lwjgl/lwjgl-opengl/3.2.2", "", "libraries/org/lwjgl/lwjgl-jemalloc/3.2.2", "")));
            OSTrigger nonMacTrigger = new OSTrigger(JVMHelper.OS.MACOSX);
            nonMacTrigger.inverted = true;
            optionalOther.triggersList = List.of(nonMacTrigger);
            optionals.add(optionalOther);
        }
        if ((logFile = MakeProfileHelper.findOption(options, MakeProfileOptionLog4j.class)).isPresent()) {
            MakeProfileOptionLog4j log4jOption = logFile.get();
            if (log4jOption.logFile != null) {
                jvmArgs.add("-Dlog4j.configurationFile=".concat(logFile.get().logFile));
            } else if (log4jOption.affected && version.compareTo(ClientProfileVersions.MINECRAFT_1_17) >= 0 && version.compareTo(ClientProfileVersions.MINECRAFT_1_18) < 0) {
                jvmArgs.add("-Dlog4j2.formatMsgNoLookups=true");
            }
        }
        builder.setMinJavaVersion(17);
        builder.setRecommendJavaVersion(17);
        if (version.compareTo(ClientProfileVersions.MINECRAFT_1_20_3) >= 0) {
            builder.setMinJavaVersion(21);
            builder.setRecommendJavaVersion(21);
        }
        jvmArgs.add("-Dfml.ignorePatchDiscrepancies=true");
        jvmArgs.add("-Dfml.ignoreInvalidMinecraftCertificates=true");
        builder.setJvmArgs(jvmArgs);
        builder.setUpdateOptional(optionals);
        ArrayList<String> clientArgs = new ArrayList<String>();
        if (version.compareTo(ClientProfileVersions.MINECRAFT_1_7_10) == 0) {
            jvmArgs.add("-Drfb.skipClassLoaderCheck=true");
        }
        if (MakeProfileHelper.findOption(options, MakeProfileOptionLaunchWrapper.class).isPresent() || MakeProfileHelper.findOption(options, MakeProfileRfbOption.class).isPresent()) {
            if (MakeProfileHelper.findOption(options, MakeProfileOptionLiteLoader.class).isPresent()) {
                clientArgs.add("--tweakClass");
                clientArgs.add("com.mumfrey.liteloader.launch.LiteLoaderTweaker");
            }
            if (forge.isPresent()) {
                clientArgs.add("--tweakClass");
                if (version.compareTo(ClientProfileVersions.MINECRAFT_1_7_10) > 0) {
                    clientArgs.add("net.minecraftforge.fml.common.launcher.FMLTweaker");
                } else {
                    clientArgs.add("cpw.mods.fml.common.launcher.FMLTweaker");
                }
            }
        } else if (version.compareTo(ClientProfileVersions.MINECRAFT_1_12_2) > 0) {
            forge.ifPresent(makeProfileOptionForge -> clientArgs.addAll(makeProfileOptionForge.makeClientArgs()));
        }
        builder.setClientArgs(clientArgs);
        return builder.createClientProfile();
    }

    private static <T> Optional<T> findOption(MakeProfileOption[] options, Class<T> clazz) {
        return Arrays.stream(options).filter(o -> clazz.isAssignableFrom(o.getClass())).findFirst();
    }

    public static String getMainClassByVersion(ClientProfile.Version version, MakeProfileOption ... options) {
        if (version.compareTo(ClientProfileVersions.MINECRAFT_1_7_10) == 0) {
            return "com.gtnewhorizons.retrofuturabootstrap.Main";
        }
        if (MakeProfileHelper.findOption(options, MakeProfileOptionLaunchWrapper.class).isPresent()) {
            return "net.minecraft.launchwrapper.Launch";
        }
        if (MakeProfileHelper.findOption(options, MakeProfileOptionForge.class).isPresent() && version.compareTo(ClientProfileVersions.MINECRAFT_1_12_2) > 0) {
            return "cpw.mods.modlauncher.Launcher";
        }
        if (MakeProfileHelper.findOption(options, MakeProfileOptionFabric.class).isPresent()) {
            return "net.fabricmc.loader.impl.launch.knot.KnotClient";
        }
        if (MakeProfileHelper.findOption(options, MakeProfilesOptionsQuilt.class).isPresent()) {
            return "org.quiltmc.loader.impl.launch.knot.KnotClient";
        }
        return "net.minecraft.client.main.Main";
    }

    private static boolean isAffectedLog4jVersion(String version) {
        if (version == null) {
            return true;
        }
        String[] split = version.split("\\.");
        if (split.length < 2) {
            return true;
        }
        if (!split[0].equals("2")) {
            return false;
        }
        return Integer.parseInt(split[1]) < 15;
    }

    private static String getLog4jVersion(Path dir) throws IOException {
        Path target;
        Path log4jCore = dir.resolve("org/apache/logging/log4j/log4j-core");
        if (Files.exists(log4jCore, new LinkOption[0]) && (target = (Path)Files.list(log4jCore).findFirst().orElse(null)) != null) {
            return target.getFileName().toString();
        }
        return null;
    }

    public static MakeProfileOption[] getMakeProfileOptionsFromDir(Path dir, ClientProfile.Version version) throws IOException {
        String log4jVersion;
        ArrayList<MakeProfileOption> options = new ArrayList<MakeProfileOption>(2);
        if (Files.exists(dir.resolve("forge.jar"), new LinkOption[0])) {
            options.add(new MakeProfileOptionForge());
        } else if (Files.exists(dir.resolve("libraries/net/minecraftforge/forge"), new LinkOption[0])) {
            if (version.compareTo(ClientProfileVersions.MINECRAFT_1_12_2) > 0) {
                options.add(new MakeProfileOptionForge(dir));
            } else {
                options.add(new MakeProfileOptionForge());
            }
        }
        if (Files.exists(dir.resolve("libraries/net/fabricmc/fabric-loader"), new LinkOption[0])) {
            options.add(new MakeProfileOptionFabric(dir));
        }
        if (Files.exists(dir.resolve("libraries/org/quiltmc/quilt-loader"), new LinkOption[0])) {
            options.add(new MakeProfilesOptionsQuilt());
        }
        if ((log4jVersion = MakeProfileHelper.getLog4jVersion(dir)) != null) {
            boolean affected = MakeProfileHelper.isAffectedLog4jVersion(log4jVersion);
            if (Files.exists(dir.resolve("log4j2_custom.xml"), new LinkOption[0])) {
                options.add(new MakeProfileOptionLog4j(affected, "log4j2_custom.xml"));
            } else {
                options.add(new MakeProfileOptionLog4j(affected, null));
            }
        }
        if (Files.exists(dir.resolve("liteloader.jar"), new LinkOption[0])) {
            options.add(new MakeProfileOptionLiteLoader());
        }
        if (Files.exists(dir.resolve("libraries/org/lwjgl/lwjgl/3.2.2"), new LinkOption[0]) && Files.exists(dir.resolve("libraries/org/lwjgl/lwjgl/3.2.1"), new LinkOption[0])) {
            options.add(new MakeProfileOptionLwjgl());
        }
        if (Files.exists(dir.resolve("libraries/forge/launchwrapper-1.12-launcherfixed.jar.jar"), new LinkOption[0]) || Files.exists(dir.resolve("libraries/net/minecraft/launchwrapper"), new LinkOption[0])) {
            options.add(new MakeProfileOptionLaunchWrapper());
        }
        return options.toArray(new MakeProfileOption[0]);
    }

    private static Path findFirstDir(Path path) throws IOException {
        return Files.list(path).findFirst().orElse(null);
    }

    private static Path findFirstMavenFile(Path path) throws IOException {
        return Files.list(Files.list(path).findFirst().orElseThrow()).filter(e -> e.getFileName().toString().endsWith(".jar")).findFirst().orElseThrow();
    }

    public static interface MakeProfileOption {
    }

    public record Lwjgl3ifyOption(String lwjgl3ifyForgePatches) implements MakeProfileOption
    {
    }

    public static class MakeProfileOptionLaunchWrapper
    implements MakeProfileOption {
    }

    public static class MakeProfileOptionForge
    implements MakeProfileOption {
        public String launchTarget;
        public String forgeVersion;
        public String forgeGroup;
        public String minecraftVersion;
        public String mcpVersion;

        public MakeProfileOptionForge() {
        }

        public MakeProfileOptionForge(String launchTarget, String forgeVersion, String forgeGroup, String minecraftVersion, String mcpVersion) {
            this.launchTarget = launchTarget;
            this.forgeVersion = forgeVersion;
            this.forgeGroup = forgeGroup;
            this.minecraftVersion = minecraftVersion;
            this.mcpVersion = mcpVersion;
        }

        public MakeProfileOptionForge(Path clientDir) throws IOException {
            Path libraries = clientDir.resolve("libraries");
            if (!Files.exists(libraries, new LinkOption[0])) {
                throw new IOException("libraries not found");
            }
            Path forgePath = MakeProfileHelper.findFirstDir(libraries.resolve("net/minecraftforge/forge"));
            if (forgePath == null) {
                throw new IOException("forge not found");
            }
            String[] forgeFullVersion = forgePath.getFileName().toString().split("-");
            this.minecraftVersion = forgeFullVersion[0];
            this.forgeVersion = forgeFullVersion[1];
            this.launchTarget = "fmlclient";
            this.forgeGroup = "net.minecraftforge";
            Path minecraftPath = MakeProfileHelper.findFirstDir(libraries.resolve("net/minecraft/client"));
            if (minecraftPath == null) {
                throw new IOException("mcp not found");
            }
            String[] minecraftFullVersion = minecraftPath.getFileName().toString().split("-");
            this.mcpVersion = minecraftFullVersion[1];
        }

        public List<String> makeClientArgs() {
            if (this.launchTarget == null) {
                return List.of();
            }
            return List.of("--launchTarget", this.launchTarget, "--fml.forgeVersion", this.forgeVersion, "--fml.mcVersion", this.minecraftVersion, "--fml.forgeGroup", this.forgeGroup, "--fml.mcpVersion", this.mcpVersion);
        }
    }

    public static class MakeProfileOptionLiteLoader
    implements MakeProfileOption {
    }

    public static class MakeProfileOptionFabric
    implements MakeProfileOption {
        public String jimfsPath;
        public String guavaPath;

        public MakeProfileOptionFabric() {
        }

        public MakeProfileOptionFabric(String jimfsPath, String guavaPath) {
            this.jimfsPath = jimfsPath;
            this.guavaPath = guavaPath;
        }

        public MakeProfileOptionFabric(Path clientDir) throws IOException {
            if (Files.exists(clientDir.resolve("libraries/com/google/jimfs/jimfs"), new LinkOption[0])) {
                this.jimfsPath = clientDir.relativize(MakeProfileHelper.findFirstMavenFile(clientDir.resolve("libraries/com/google/jimfs/jimfs"))).toString();
                this.guavaPath = clientDir.relativize(MakeProfileHelper.findFirstMavenFile(clientDir.resolve("libraries/com/google/guava/guava/"))).toString();
            }
        }

        public List<String> getAltClassPath() {
            if (this.jimfsPath == null || this.guavaPath == null) {
                return List.of();
            }
            return List.of(this.jimfsPath, this.guavaPath);
        }
    }

    public static class MakeProfilesOptionsQuilt
    implements MakeProfileOption {
    }

    public static class MakeProfileOptionLwjgl
    implements MakeProfileOption {
    }

    public static class MakeProfileOptionLog4j
    implements MakeProfileOption {
        public boolean affected;
        public String logFile;

        public MakeProfileOptionLog4j(boolean lower15, String logFile) {
            this.affected = lower15;
            this.logFile = logFile;
        }
    }

    public static class MakeProfileRfbOption
    implements MakeProfileOption {
    }
}

