/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.server;

import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.jar.JarFile;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public class ServerAgent {
    private static boolean isAgentStarted = false;
    public static Instrumentation inst = null;
    public static Boolean isAutoloadLibraries = Boolean.getBoolean(System.getProperty("serverwrapper,agentlibrariesload", "false"));
    public static Boolean isAgentProxy = Boolean.getBoolean(System.getProperty("serverwrapper,agentproxy", "false"));

    public static void addJVMClassPath(String path) throws IOException {
        LogHelper.debug((String)"Load %s", (Object[])new Object[]{path});
        inst.appendToSystemClassLoaderSearch(new JarFile(path));
    }

    public static void addJVMClassPath(JarFile file) {
        LogHelper.debug((String)"Load %s", (Object[])new Object[]{file.getName()});
        inst.appendToSystemClassLoaderSearch(file);
    }

    public static boolean isAgentStarted() {
        return isAgentStarted;
    }

    public static long getObjSize(Object obj) {
        return inst.getObjectSize(obj);
    }

    public static void premain(String agentArgument, Instrumentation instrumentation) {
        Path libraries;
        LogHelper.debug((String)"Server Agent");
        inst = instrumentation;
        isAgentStarted = true;
        if (isAutoloadLibraries.booleanValue() && IOHelper.exists((Path)(libraries = Paths.get("libraries", new String[0])))) {
            ServerAgent.loadLibraries(libraries);
        }
        if (isAgentProxy.booleanValue()) {
            String proxyClassName = System.getProperty("serverwrapper.agentproxyclass");
            try {
                Class<?> proxyClass = Class.forName(proxyClassName);
                MethodHandle mainMethod = MethodHandles.publicLookup().findStatic(proxyClass, "premain", MethodType.methodType(Void.TYPE, String.class, Instrumentation.class));
                mainMethod.invoke(agentArgument, instrumentation);
            }
            catch (Throwable e) {
                LogHelper.error((Throwable)e);
            }
        }
    }

    public static void loadLibraries(Path dir) {
        try {
            IOHelper.walk((Path)dir, (FileVisitor)new StarterVisitor(), (boolean)true);
        }
        catch (IOException e) {
            LogHelper.error((Throwable)e);
        }
    }

    private static final class StarterVisitor
    extends SimpleFileVisitor<Path> {
        private StarterVisitor() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (file.toFile().getName().endsWith(".jar")) {
                ServerAgent.addJVMClassPath(new JarFile(file.toFile()));
            }
            return super.visitFile(file, attrs);
        }
    }
}

