/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.server.setup;

import java.io.BufferedWriter;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.jar.JarFile;
import pro.gravit.launcher.server.ServerWrapper;
import pro.gravit.launcher.server.setup.ServerWrapperCommands;
import pro.gravit.launcher.server.setup.ServerWrapperPostSetupEvent;
import pro.gravit.launcher.server.setup.ServerWrapperPreSetupEvent;
import pro.gravit.launcher.server.setup.ServerWrapperSetupEvent;
import pro.gravit.utils.PublicURLClassLoader;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;

public class ServerWrapperSetup {
    public ServerWrapperCommands commands = new ServerWrapperCommands();
    public PublicURLClassLoader urlClassLoader;

    public void run() throws IOException {
        String mainClassName;
        ServerWrapper wrapper = ServerWrapper.wrapper;
        ServerWrapper.modulesManager.invokeEvent(new ServerWrapperPreSetupEvent(this));
        System.out.println("Print jar filename:");
        String jarName = this.commands.commandHandler.readLine();
        Path jarPath = Paths.get(jarName, new String[0]);
        try (JarFile file = new JarFile(jarPath.toFile());){
            URL jarURL = jarPath.toUri().toURL();
            this.urlClassLoader = new PublicURLClassLoader(new URL[]{jarURL});
            LogHelper.info((String)"Check jar MainClass");
            mainClassName = file.getManifest().getMainAttributes().getValue("Main-Class");
            if (mainClassName == null) {
                LogHelper.error((String)"Main-Class not found in MANIFEST");
                return;
            }
            try {
                Class.forName(mainClassName, false, (ClassLoader)this.urlClassLoader);
            }
            catch (ClassNotFoundException e) {
                LogHelper.error((Throwable)e);
                file.close();
                return;
            }
        }
        LogHelper.info((String)"Found MainClass %s", (Object[])new Object[]{mainClassName});
        System.out.println("Print launchserver websocket host( ws://host:port/api ):");
        String address = this.commands.commandHandler.readLine();
        wrapper.config.mainclass = mainClassName;
        wrapper.config.address = address;
        boolean stopOnError = wrapper.config.stopOnError;
        for (int i = 0; i < 10; ++i) {
            System.out.println("Print server account login:");
            String login = this.commands.commandHandler.readLine();
            System.out.println("Print server account password:");
            String password = this.commands.commandHandler.readLine();
            System.out.println("Print profile title:");
            String title = this.commands.commandHandler.readLine();
            wrapper.config.login = login;
            wrapper.config.password = password;
            wrapper.config.title = title;
            wrapper.config.stopOnError = false;
            wrapper.updateLauncherConfig();
            if (wrapper.auth()) break;
            LogHelper.error((String)"Auth error. Recheck account params");
        }
        wrapper.config.stopOnError = stopOnError;
        wrapper.saveConfig();
        LogHelper.info((String)"Generate start script");
        Path startScript = JVMHelper.OS_TYPE == JVMHelper.OS.MUSTDIE ? Paths.get("start.bat", new String[0]) : Paths.get("start.sh", new String[0]);
        if (Files.exists(startScript, new LinkOption[0])) {
            LogHelper.warning((String)"start script found. Move to start.bak");
            Path startScriptBak = Paths.get("start.bak", new String[0]);
            IOHelper.move((Path)startScript, (Path)startScriptBak);
        }
        ServerWrapper.modulesManager.invokeEvent(new ServerWrapperSetupEvent(this));
        try (BufferedWriter writer = IOHelper.newWriter((Path)startScript);){
            if (JVMHelper.OS_TYPE == JVMHelper.OS.LINUX) {
                writer.append("#!/bin/sh\n\n");
            }
            writer.append("java ");
            if (mainClassName.contains("bungee")) {
                LogHelper.info((String)"Found BungeeCord mainclass. Modules dir change to modules_srv");
                writer.append(JVMHelper.jvmProperty((String)"serverwrapper.modulesDir", (String)"modules_srv"));
                writer.append(" ");
            }
            writer.append("-cp ");
            String pathServerWrapper = IOHelper.getCodeSource(ServerWrapper.class).getFileName().toString();
            writer.append(pathServerWrapper);
            if (JVMHelper.OS_TYPE == JVMHelper.OS.MUSTDIE) {
                writer.append(";");
            } else {
                writer.append(":");
            }
            writer.append(jarName);
            writer.append(" ");
            writer.append(ServerWrapper.class.getName());
            writer.append("\n");
        }
        ServerWrapper.modulesManager.invokeEvent(new ServerWrapperPostSetupEvent(this));
    }
}

