/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.server;

import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.interfaces.ECPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.HashMap;
import pro.gravit.launcher.ClientPermissions;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherConfig;
import pro.gravit.launcher.config.JsonConfigurable;
import pro.gravit.launcher.events.request.AuthRequestEvent;
import pro.gravit.launcher.events.request.ProfilesRequestEvent;
import pro.gravit.launcher.modules.LauncherModule;
import pro.gravit.launcher.modules.events.PostInitPhase;
import pro.gravit.launcher.modules.events.PreConfigPhase;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launcher.profiles.PlayerProfile;
import pro.gravit.launcher.profiles.optional.actions.OptionalAction;
import pro.gravit.launcher.request.Request;
import pro.gravit.launcher.request.RequestException;
import pro.gravit.launcher.request.auth.AuthRequest;
import pro.gravit.launcher.request.update.ProfilesRequest;
import pro.gravit.launcher.server.ServerAgent;
import pro.gravit.launcher.server.ServerWrapperGsonManager;
import pro.gravit.launcher.server.ServerWrapperInitPhase;
import pro.gravit.launcher.server.ServerWrapperModulesManager;
import pro.gravit.launcher.server.setup.ServerWrapperSetup;
import pro.gravit.utils.PublicURLClassLoader;
import pro.gravit.utils.helper.CommonHelper;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;

public class ServerWrapper
extends JsonConfigurable<Config> {
    public static final Path modulesDir = Paths.get(System.getProperty("serverwrapper.modulesDir", "modules"), new String[0]);
    public static final Path modulesConfigDir = Paths.get(System.getProperty("serverwrapper.modulesConfigDir", "modules-config"), new String[0]);
    public static final Path configFile = Paths.get(System.getProperty("serverwrapper.configFile", "ServerWrapperConfig.json"), new String[0]);
    public static final Path publicKeyFile = Paths.get(System.getProperty("serverwrapper.publicKeyFile", "public.key"), new String[0]);
    public static final boolean disableSetup = Boolean.parseBoolean(System.getProperty("serverwrapper.disableSetup", "false"));
    public static ServerWrapperModulesManager modulesManager;
    public static ServerWrapper wrapper;
    public Config config;
    public PublicURLClassLoader ucp;
    public ClassLoader loader;
    public ClientPermissions permissions;
    public ClientProfile profile;
    public PlayerProfile playerProfile;
    public ClientProfile.ServerProfile serverProfile;

    public ServerWrapper(Type type, Path configPath) {
        super(type, configPath);
    }

    public static void initGson(ServerWrapperModulesManager modulesManager) {
        Launcher.gsonManager = new ServerWrapperGsonManager(modulesManager);
        Launcher.gsonManager.initGson();
    }

    public static void main(String ... args) throws Throwable {
        LogHelper.printVersion((String)"ServerWrapper");
        LogHelper.printLicense((String)"ServerWrapper");
        modulesManager = new ServerWrapperModulesManager(modulesDir, modulesConfigDir);
        modulesManager.autoload();
        modulesManager.initModules(null);
        wrapper = new ServerWrapper((Type)((Object)Config.class), configFile);
        wrapper.run(args);
    }

    public boolean auth() {
        try {
            Launcher.getConfig();
            AuthRequest request = new AuthRequest(this.config.login, this.config.password, this.config.auth_id, AuthRequest.ConnectTypes.API);
            AuthRequestEvent authResult = (AuthRequestEvent)request.request();
            this.permissions = authResult.permissions;
            this.playerProfile = authResult.playerProfile;
            ProfilesRequestEvent result = (ProfilesRequestEvent)new ProfilesRequest().request();
            for (ClientProfile p : result.profiles) {
                LogHelper.debug((String)"Get profile: %s", (Object[])new Object[]{p.getTitle()});
                boolean isFound = false;
                for (ClientProfile.ServerProfile srv : p.getServers()) {
                    if (srv == null || !srv.name.equals(this.config.serverName)) continue;
                    this.serverProfile = srv;
                    this.profile = p;
                    Launcher.profile = p;
                    LogHelper.debug((String)"Found profile: %s", (Object[])new Object[]{Launcher.profile.getTitle()});
                    isFound = true;
                    break;
                }
                if (!isFound) continue;
                break;
            }
            if (this.profile == null) {
                LogHelper.warning((String)"Not connected to ServerProfile. May be serverName incorrect?");
            }
            return true;
        }
        catch (Throwable e) {
            LogHelper.error((Throwable)e);
            if (this.config.stopOnError) {
                System.exit(-1);
            }
            return false;
        }
    }

    public boolean loopAuth(int count, int sleeptime) {
        if (count == 0) {
            while (!this.auth()) {
            }
            return true;
        }
        for (int i = 0; i < count; ++i) {
            if (this.auth()) {
                return true;
            }
            try {
                Thread.sleep(sleeptime);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LogHelper.error((Throwable)e);
                return false;
            }
        }
        return false;
    }

    public void run(String ... args) throws Throwable {
        String classname;
        ServerWrapper.initGson(modulesManager);
        AuthRequest.registerProviders();
        OptionalAction.registerProviders();
        if (args.length > 0 && args[0].equals("setup") && !disableSetup) {
            LogHelper.debug((String)"Read ServerWrapperConfig.json");
            this.loadConfig();
            ServerWrapperSetup setup = new ServerWrapperSetup();
            setup.run();
            System.exit(0);
        }
        modulesManager.invokeEvent((LauncherModule.Event)new PreConfigPhase());
        LogHelper.debug((String)"Read ServerWrapperConfig.json");
        this.loadConfig();
        this.updateLauncherConfig();
        if (this.config.env != null) {
            Launcher.applyLauncherEnv((LauncherConfig.LauncherEnvironment)this.config.env);
        } else {
            Launcher.applyLauncherEnv((LauncherConfig.LauncherEnvironment)LauncherConfig.LauncherEnvironment.STD);
        }
        if (this.config.logFile != null) {
            LogHelper.addOutput((Writer)IOHelper.newWriter((Path)Paths.get(this.config.logFile, new String[0]), (boolean)true));
        }
        if (this.config.syncAuth) {
            this.auth();
        } else {
            CommonHelper.newThread((String)"Server Auth Thread", (boolean)true, () -> this.loopAuth(this.config.reconnectCount, this.config.reconnectSleep));
        }
        modulesManager.invokeEvent(new ServerWrapperInitPhase(this));
        String string = classname = this.config.mainclass == null || this.config.mainclass.isEmpty() ? args[0] : this.config.mainclass;
        if (classname.length() == 0) {
            LogHelper.error((String)"MainClass not found. Please set MainClass for ServerWrapper.cfg or first commandline argument");
            if (this.config.stopOnError) {
                System.exit(-1);
            }
        }
        if (this.config.customClassPath) {
            if (this.config.classpath == null) {
                throw new UnsupportedOperationException("classpath is null, customClassPath not available");
            }
            String[] cp = this.config.classpath.split(":");
            if (!ServerAgent.isAgentStarted()) {
                LogHelper.warning((String)"JavaAgent not found. Using URLClassLoader");
                Object[] urls = (URL[])Arrays.stream(cp).map(x$0 -> Paths.get(x$0, new String[0])).map(IOHelper::toURL).toArray(URL[]::new);
                this.ucp = new PublicURLClassLoader((URL[])urls);
                Thread.currentThread().setContextClassLoader((ClassLoader)this.ucp);
                this.loader = this.ucp;
            } else {
                LogHelper.info((String)"Found %d custom classpath elements", (Object[])new Object[]{cp.length});
                for (String c : cp) {
                    ServerAgent.addJVMClassPath(c);
                }
            }
        }
        if (this.config.autoloadLibraries) {
            if (!ServerAgent.isAgentStarted()) {
                throw new UnsupportedOperationException("JavaAgent not found, autoloadLibraries not available");
            }
            if (this.config.librariesDir == null) {
                throw new UnsupportedOperationException("librariesDir is null, autoloadLibraries not available");
            }
            Path librariesDir = Paths.get(this.config.librariesDir, new String[0]);
            LogHelper.info((String)"Load libraries");
            ServerAgent.loadLibraries(librariesDir);
        }
        Class<?> mainClass = this.loader != null ? Class.forName(classname, true, this.loader) : Class.forName(classname);
        MethodHandle mainMethod = MethodHandles.publicLookup().findStatic(mainClass, "main", MethodType.methodType(Void.TYPE, String[].class));
        modulesManager.invokeEvent((LauncherModule.Event)new PostInitPhase());
        Request.service.reconnectCallback = () -> {
            LogHelper.debug((String)"WebSocket connect closed. Try reconnect");
            try {
                Request.service.open();
                LogHelper.debug((String)"Connect to %s", (Object[])new Object[]{this.config.address});
            }
            catch (Exception e) {
                LogHelper.error((Throwable)e);
                throw new RequestException(String.format("Connect error: %s", e.getMessage() != null ? e.getMessage() : "null"));
            }
            this.auth();
        };
        LogHelper.info((String)"ServerWrapper: Project %s, LaunchServer address: %s. Title: %s", (Object[])new Object[]{this.config.projectname, this.config.address, Launcher.profile != null ? Launcher.profile.getTitle() : "unknown"});
        LogHelper.info((String)"Minecraft Version (for profile): %s", (Object[])new Object[]{ServerWrapper.wrapper.profile == null ? "unknown" : ServerWrapper.wrapper.profile.getVersion().name});
        LogHelper.info((String)"Start Minecraft Server");
        LogHelper.debug((String)"Invoke main method %s", (Object[])new Object[]{mainClass.getName()});
        if (this.config.args == null) {
            String[] real_args;
            if (args.length > 0) {
                real_args = new String[args.length - 1];
                System.arraycopy(args, 1, real_args, 0, args.length - 1);
            } else {
                real_args = args;
            }
            mainMethod.invoke(real_args);
        } else {
            mainMethod.invoke(this.config.args);
        }
    }

    public void updateLauncherConfig() {
        LauncherConfig cfg = null;
        try {
            ECPublicKey publicKey = null;
            if (IOHelper.isFile((Path)publicKeyFile)) {
                publicKey = SecurityHelper.toPublicECKey((byte[])IOHelper.read((Path)publicKeyFile));
            }
            cfg = new LauncherConfig(this.config.address, publicKey, new HashMap(), this.config.projectname);
            cfg.address = this.config.address;
        }
        catch (IOException | InvalidKeySpecException e) {
            LogHelper.error((Throwable)e);
        }
        Launcher.setConfig(cfg);
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public Config getDefaultConfig() {
        Config newConfig = new Config();
        newConfig.serverName = "your server name";
        newConfig.projectname = "MineCraft";
        newConfig.login = "login";
        newConfig.password = "password";
        newConfig.mainclass = "";
        newConfig.syncAuth = true;
        newConfig.stopOnError = true;
        newConfig.reconnectCount = 10;
        newConfig.reconnectSleep = 1000;
        newConfig.websocket = new WebSocketConf();
        newConfig.address = "ws://localhost:9274/api";
        newConfig.env = LauncherConfig.LauncherEnvironment.STD;
        return newConfig;
    }

    public static final class WebSocketConf {
    }

    public static final class Config {
        @Deprecated
        public String title;
        public String projectname;
        public String address;
        public String serverName;
        public WebSocketConf websocket;
        public int reconnectCount;
        public int reconnectSleep;
        public boolean customClassPath;
        public boolean autoloadLibraries;
        public boolean stopOnError;
        public boolean syncAuth;
        public String logFile;
        public String classpath;
        public String librariesDir;
        public String mainclass;
        public String login;
        public String[] args;
        public String password;
        public String auth_id = "";
        public LauncherConfig.LauncherEnvironment env;
    }
}

