/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.server;

import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pro.gravit.launcher.ClientPermissions;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherConfig;
import pro.gravit.launcher.config.JsonConfigurable;
import pro.gravit.launcher.events.request.AuthRequestEvent;
import pro.gravit.launcher.events.request.ProfilesRequestEvent;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launcher.profiles.PlayerProfile;
import pro.gravit.launcher.profiles.optional.actions.OptionalAction;
import pro.gravit.launcher.profiles.optional.triggers.OptionalTrigger;
import pro.gravit.launcher.request.Request;
import pro.gravit.launcher.request.RequestService;
import pro.gravit.launcher.request.auth.AuthRequest;
import pro.gravit.launcher.request.auth.GetAvailabilityAuthRequest;
import pro.gravit.launcher.request.update.ProfilesRequest;
import pro.gravit.launcher.request.websockets.StdWebSocketService;
import pro.gravit.launcher.server.ServerAgent;
import pro.gravit.launcher.server.ServerWrapperGsonManager;
import pro.gravit.launcher.server.launch.ClasspathLaunch;
import pro.gravit.launcher.server.launch.Launch;
import pro.gravit.launcher.server.launch.ModuleLaunch;
import pro.gravit.launcher.server.launch.SimpleLaunch;
import pro.gravit.launcher.server.setup.ServerWrapperSetup;
import pro.gravit.utils.PublicURLClassLoader;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public class ServerWrapper
extends JsonConfigurable<Config> {
    public static final Path configFile = Paths.get(System.getProperty("serverwrapper.configFile", "ServerWrapperConfig.json"), new String[0]);
    public static final boolean disableSetup = Boolean.parseBoolean(System.getProperty("serverwrapper.disableSetup", "false"));
    public static ServerWrapper wrapper;
    public Config config;
    public PublicURLClassLoader ucp;
    public ClassLoader loader;
    public ClientPermissions permissions;
    public ClientProfile profile;
    public PlayerProfile playerProfile;
    public ClientProfile.ServerProfile serverProfile;

    public ServerWrapper(Type type, Path configPath) {
        super(type, configPath);
    }

    public static void initGson() {
        Launcher.gsonManager = new ServerWrapperGsonManager();
        Launcher.gsonManager.initGson();
    }

    public static void main(String ... args) throws Throwable {
        LogHelper.printVersion((String)"ServerWrapper");
        LogHelper.printLicense((String)"ServerWrapper");
        wrapper = new ServerWrapper((Type)((Object)Config.class), configFile);
        wrapper.run(args);
    }

    public void restore() throws Exception {
        if (this.config.oauth != null) {
            Request.setOAuth((String)this.config.authId, (AuthRequestEvent.OAuthRequestEvent)this.config.oauth, (long)this.config.oauthExpireTime);
        }
        if (this.config.extendedTokens != null) {
            Request.addAllExtendedToken(this.config.extendedTokens);
        }
        Request.restore();
    }

    public ProfilesRequestEvent getProfiles() throws Exception {
        ProfilesRequestEvent result = (ProfilesRequestEvent)new ProfilesRequest().request();
        for (ClientProfile p : result.profiles) {
            LogHelper.debug((String)"Get profile: %s", (Object[])new Object[]{p.getTitle()});
            boolean isFound = false;
            for (ClientProfile.ServerProfile srv : p.getServers()) {
                if (srv == null || !srv.name.equals(this.config.serverName)) continue;
                this.serverProfile = srv;
                this.profile = p;
                Launcher.profile = p;
                LogHelper.debug((String)"Found profile: %s", (Object[])new Object[]{Launcher.profile.getTitle()});
                isFound = true;
                break;
            }
            if (!isFound) continue;
            break;
        }
        if (this.profile == null) {
            LogHelper.warning((String)"Not connected to ServerProfile. May be serverName incorrect?");
        }
        return result;
    }

    public void run(String ... args) throws Throwable {
        Launch launch;
        String[] real_args;
        String classname;
        ServerWrapper.initGson();
        AuthRequest.registerProviders();
        GetAvailabilityAuthRequest.registerProviders();
        OptionalAction.registerProviders();
        OptionalTrigger.registerProviders();
        if (args.length > 0 && args[0].equals("setup") && !disableSetup) {
            LogHelper.debug((String)"Read ServerWrapperConfig.json");
            this.loadConfig();
            ServerWrapperSetup setup = new ServerWrapperSetup();
            setup.run();
            System.exit(0);
        }
        LogHelper.debug((String)"Read ServerWrapperConfig.json");
        this.loadConfig();
        this.updateLauncherConfig();
        if (this.config.env != null) {
            Launcher.applyLauncherEnv((LauncherConfig.LauncherEnvironment)this.config.env);
        } else {
            Launcher.applyLauncherEnv((LauncherConfig.LauncherEnvironment)LauncherConfig.LauncherEnvironment.STD);
        }
        StdWebSocketService service = (StdWebSocketService)StdWebSocketService.initWebSockets((String)this.config.address).get();
        service.reconnectCallback = () -> {
            LogHelper.debug((String)"WebSocket connect closed. Try reconnect");
            try {
                Request.reconnect();
                this.getProfiles();
            }
            catch (Exception e) {
                LogHelper.error((Throwable)e);
            }
        };
        Request.setRequestService((RequestService)service);
        if (this.config.logFile != null) {
            LogHelper.addOutput((Writer)IOHelper.newWriter((Path)Paths.get(this.config.logFile, new String[0]), (boolean)true));
        }
        this.restore();
        this.getProfiles();
        String string = classname = this.config.mainclass == null || this.config.mainclass.isEmpty() ? args[0] : this.config.mainclass;
        if (classname.length() == 0) {
            LogHelper.error((String)"MainClass not found. Please set MainClass for ServerWrapper.json or first commandline argument");
            System.exit(-1);
        }
        if (this.config.oauth == null && (this.config.extendedTokens == null || this.config.extendedTokens.isEmpty())) {
            LogHelper.error((String)"Auth not configured. Please use 'java -jar ServerWrapper.jar setup'");
            System.exit(-1);
        }
        if (this.config.autoloadLibraries) {
            if (!ServerAgent.isAgentStarted()) {
                throw new UnsupportedOperationException("JavaAgent not found, autoloadLibraries not available");
            }
            if (this.config.librariesDir == null) {
                throw new UnsupportedOperationException("librariesDir is null, autoloadLibraries not available");
            }
            Path librariesDir = Paths.get(this.config.librariesDir, new String[0]);
            LogHelper.info((String)"Load libraries");
            ServerAgent.loadLibraries(librariesDir);
        }
        LogHelper.info((String)"ServerWrapper: LaunchServer address: %s. Title: %s", (Object[])new Object[]{this.config.address, Launcher.profile != null ? Launcher.profile.getTitle() : "unknown"});
        LogHelper.info((String)"Minecraft Version (for profile): %s", (Object[])new Object[]{ServerWrapper.wrapper.profile == null ? "unknown" : ServerWrapper.wrapper.profile.getVersion().name});
        if (args.length > 0) {
            real_args = new String[args.length - 1];
            System.arraycopy(args, 1, real_args, 0, args.length - 1);
        } else {
            real_args = args;
        }
        switch (this.config.classLoaderConfig) {
            case LAUNCHER: {
                launch = new ClasspathLaunch();
                break;
            }
            case MODULE: {
                launch = new ModuleLaunch();
                break;
            }
            default: {
                launch = new SimpleLaunch();
            }
        }
        LogHelper.info((String)"Start Minecraft Server");
        LogHelper.debug((String)"Invoke main method %s with %s", (Object[])new Object[]{this.config.mainclass, launch.getClass().getName()});
        try {
            launch.run(this.config, real_args);
        }
        catch (Throwable e) {
            LogHelper.error((Throwable)e);
            System.exit(-1);
        }
        System.exit(0);
    }

    public void updateLauncherConfig() {
        LauncherConfig cfg = new LauncherConfig(this.config.address, null, null, new HashMap(), "ServerWrapper");
        Launcher.setConfig((LauncherConfig)cfg);
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public Config getDefaultConfig() {
        Config newConfig = new Config();
        newConfig.serverName = "your server name";
        newConfig.mainclass = "";
        newConfig.extendedTokens = new HashMap<String, String>();
        newConfig.args = new ArrayList<String>();
        newConfig.classpath = new ArrayList<String>();
        newConfig.address = "ws://localhost:9274/api";
        newConfig.classLoaderConfig = ClientProfile.ClassLoaderConfig.SYSTEM_ARGS;
        newConfig.env = LauncherConfig.LauncherEnvironment.STD;
        return newConfig;
    }

    public static final class Config {
        @Deprecated
        public String projectname;
        public String address;
        public String serverName;
        public boolean autoloadLibraries;
        public String logFile;
        public List<String> classpath;
        public ClientProfile.ClassLoaderConfig classLoaderConfig;
        public String librariesDir;
        public String mainclass;
        public List<String> args;
        public String authId;
        public AuthRequestEvent.OAuthRequestEvent oauth;
        public long oauthExpireTime;
        public Map<String, String> extendedTokens;
        public LauncherConfig.LauncherEnvironment env;
        public ModuleConf moduleConf = new ModuleConf();
    }

    public static final class ModuleConf {
        public List<String> modules = new ArrayList<String>();
        public List<String> modulePath = new ArrayList<String>();
        public String mainModule = "";
        public Map<String, String> exports = new HashMap<String, String>();
        public Map<String, String> opens = new HashMap<String, String>();
        public Map<String, String> reads = new HashMap<String, String>();
    }
}

