/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.server.launch;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.module.Configuration;
import java.lang.module.ModuleFinder;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import pro.gravit.launcher.server.ServerWrapper;
import pro.gravit.launcher.server.launch.Launch;
import pro.gravit.utils.PublicURLClassLoader;
import pro.gravit.utils.helper.IOHelper;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ModuleLaunch
implements Launch {
    @Override
    public void run(String mainclass, ServerWrapper.Config config, String[] args) throws Throwable {
        Module target;
        String pkg;
        Module source;
        String[] split;
        URL[] urls = (URL[])config.classpath.stream().map(x$0 -> Paths.get(x$0, new String[0])).map(IOHelper::toURL).toArray(URL[]::new);
        PublicURLClassLoader ucl = new PublicURLClassLoader(urls);
        ModuleFinder finder = ModuleFinder.of((Path[])config.moduleConf.modulePath.stream().map(x$0 -> Paths.get(x$0, new String[0])).toArray(Path[]::new));
        ModuleLayer bootLayer = ModuleLayer.boot();
        Configuration configuration = bootLayer.configuration().resolveAndBind(ModuleFinder.of(new Path[0]), finder, config.moduleConf.modules);
        ModuleLayer.Controller controller = ModuleLayer.defineModulesWithOneLoader(configuration, List.of(bootLayer), (ClassLoader)ucl);
        ModuleLayer layer = controller.layer();
        for (Map.Entry<String, String> e : config.moduleConf.exports.entrySet()) {
            split = e.getKey().split("\\\\");
            source = layer.findModule(split[0]).orElseThrow();
            pkg = split[1];
            target = layer.findModule(e.getValue()).orElseThrow();
            controller.addExports(source, pkg, target);
        }
        for (Map.Entry<String, String> e : config.moduleConf.opens.entrySet()) {
            split = e.getKey().split("\\\\");
            source = layer.findModule(split[0]).orElseThrow();
            pkg = split[1];
            target = layer.findModule(e.getValue()).orElseThrow();
            controller.addOpens(source, pkg, target);
        }
        for (Map.Entry<String, String> e : config.moduleConf.reads.entrySet()) {
            Module source2 = layer.findModule(e.getKey()).orElseThrow();
            Module target2 = layer.findModule(e.getValue()).orElseThrow();
            controller.addReads(source2, target2);
        }
        Module mainModule = layer.findModule(config.moduleConf.mainModule).orElseThrow();
        Module unnamed = ModuleLaunch.class.getClassLoader().getUnnamedModule();
        if (unnamed != null) {
            controller.addOpens(mainModule, ModuleLaunch.getPackageFromClass(config.mainclass), unnamed);
        }
        ClassLoader loader = mainModule.getClassLoader();
        Class<?> mainClass = Class.forName(mainclass, true, loader);
        MethodHandle mainMethod = MethodHandles.lookup().findStatic(mainClass, "main", MethodType.methodType(Void.TYPE, String[].class));
        mainMethod.invoke(args);
    }

    private static String getPackageFromClass(String clazz) {
        int index = clazz.lastIndexOf(".");
        if (index >= 0) {
            return clazz.substring(0, index);
        }
        return clazz;
    }
}

