/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.server;

import java.io.File;
import java.io.Writer;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launcher.base.LauncherConfig;
import pro.gravit.launcher.base.api.AuthService;
import pro.gravit.launcher.base.api.ClientService;
import pro.gravit.launcher.base.api.ConfigService;
import pro.gravit.launcher.base.api.KeyService;
import pro.gravit.launcher.base.config.JsonConfigurable;
import pro.gravit.launcher.base.events.request.AuthRequestEvent;
import pro.gravit.launcher.base.events.request.ProfilesRequestEvent;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launcher.base.profiles.optional.actions.OptionalAction;
import pro.gravit.launcher.base.profiles.optional.triggers.OptionalTrigger;
import pro.gravit.launcher.base.request.Request;
import pro.gravit.launcher.base.request.RequestService;
import pro.gravit.launcher.base.request.auth.AuthRequest;
import pro.gravit.launcher.base.request.auth.GetAvailabilityAuthRequest;
import pro.gravit.launcher.base.request.update.ProfilesRequest;
import pro.gravit.launcher.base.request.websockets.StdWebSocketService;
import pro.gravit.launcher.server.ServerAgent;
import pro.gravit.launcher.server.ServerWrapperGsonManager;
import pro.gravit.launcher.server.authlib.InstallAuthlib;
import pro.gravit.launcher.server.setup.ServerWrapperSetup;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;
import pro.gravit.utils.launch.BasicLaunch;
import pro.gravit.utils.launch.ClassLoaderControl;
import pro.gravit.utils.launch.LaunchOptions;
import pro.gravit.utils.launch.LegacyLaunch;
import pro.gravit.utils.launch.ModuleLaunch;

public class ServerWrapper
extends JsonConfigurable<Config> {
    public static final Path configFile = Paths.get(System.getProperty("serverwrapper.configFile", "ServerWrapperConfig.json"), new String[0]);
    public static final boolean disableSetup = Boolean.parseBoolean(System.getProperty("serverwrapper.disableSetup", "false"));
    public static ServerWrapper wrapper;
    public static ClassLoaderControl classLoaderControl;
    public Config config;
    public ClientProfile profile;
    public ClientProfile.ServerProfile serverProfile;

    public ServerWrapper(Type type, Path configPath) {
        super(type, configPath);
    }

    public static void initGson() {
        Launcher.gsonManager = new ServerWrapperGsonManager();
        Launcher.gsonManager.initGson();
    }

    public static void main(String ... args) throws Throwable {
        LogHelper.printVersion((String)"ServerWrapper");
        LogHelper.printLicense((String)"ServerWrapper");
        wrapper = new ServerWrapper((Type)((Object)Config.class), configFile);
        wrapper.run(args);
    }

    public void restore() throws Exception {
        if (this.config.oauth != null) {
            Request.setOAuth((String)this.config.authId, (AuthRequestEvent.OAuthRequestEvent)this.config.oauth, (long)this.config.oauthExpireTime);
        }
        if (this.config.extendedTokens != null) {
            Request.addAllExtendedToken(this.config.extendedTokens);
        }
        Request.RequestRestoreReport report = Request.restore((this.config.oauth != null ? 1 : 0) != 0, (boolean)false, (boolean)false);
        if (report.userInfo != null) {
            if (report.userInfo.playerProfile != null) {
                AuthService.username = report.userInfo.playerProfile.username;
                AuthService.uuid = report.userInfo.playerProfile.uuid;
            }
            AuthService.permissions = report.userInfo.permissions;
        }
    }

    public void getProfiles() throws Exception {
        ProfilesRequestEvent result = (ProfilesRequestEvent)new ProfilesRequest().request();
        for (ClientProfile p : result.profiles) {
            LogHelper.debug((String)"Get profile: %s", (Object[])new Object[]{p.getTitle()});
            boolean isFound = false;
            for (ClientProfile.ServerProfile srv : p.getServers()) {
                if (srv == null || !srv.name.equals(this.config.serverName)) continue;
                this.serverProfile = srv;
                this.profile = p;
                Launcher.profile = p;
                AuthService.profile = p;
                LogHelper.debug((String)"Found profile: %s", (Object[])new Object[]{Launcher.profile.getTitle()});
                isFound = true;
                break;
            }
            if (!isFound) continue;
            break;
        }
        if (this.profile == null) {
            LogHelper.warning((String)"Not connected to ServerProfile. May be serverName incorrect?");
        }
    }

    public void run(String ... args) throws Throwable {
        LegacyLaunch launch;
        String[] real_args;
        String classname;
        ServerWrapper.initGson();
        AuthRequest.registerProviders();
        GetAvailabilityAuthRequest.registerProviders();
        OptionalAction.registerProviders();
        OptionalTrigger.registerProviders();
        if (args.length > 0 && args[0].equalsIgnoreCase("setup") && !disableSetup) {
            LogHelper.debug((String)"Read ServerWrapperConfig.json");
            this.loadConfig();
            ServerWrapperSetup setup = new ServerWrapperSetup();
            setup.run();
            System.exit(0);
        }
        if (args.length > 1 && args[0].equalsIgnoreCase("installAuthlib") && !disableSetup) {
            LogHelper.debug((String)"Read ServerWrapperConfig.json");
            this.loadConfig();
            InstallAuthlib command = new InstallAuthlib();
            command.run(args[1]);
            System.exit(0);
        }
        LogHelper.debug((String)"Read ServerWrapperConfig.json");
        this.loadConfig();
        this.updateLauncherConfig();
        Launcher.applyLauncherEnv((LauncherConfig.LauncherEnvironment)Objects.requireNonNullElse(this.config.env, LauncherConfig.LauncherEnvironment.STD));
        StdWebSocketService service = (StdWebSocketService)StdWebSocketService.initWebSockets((String)this.config.address).get();
        service.reconnectCallback = () -> {
            LogHelper.debug((String)"WebSocket connect closed. Try reconnect");
            try {
                Request.reconnect();
                this.getProfiles();
            }
            catch (Exception e) {
                LogHelper.error((Throwable)e);
            }
        };
        if (this.config.properties != null) {
            for (Map.Entry<String, String> e : this.config.properties.entrySet()) {
                System.setProperty(e.getKey(), e.getValue());
            }
        }
        Request.setRequestService((RequestService)service);
        if (this.config.logFile != null) {
            LogHelper.addOutput((Writer)IOHelper.newWriter((Path)Paths.get(this.config.logFile, new String[0]), (boolean)true));
        }
        this.restore();
        this.getProfiles();
        if (this.config.encodedServerRsaPublicKey != null) {
            KeyService.serverRsaPublicKey = SecurityHelper.toPublicRSAKey((byte[])this.config.encodedServerRsaPublicKey);
        }
        if (this.config.encodedServerEcPublicKey != null) {
            KeyService.serverEcPublicKey = SecurityHelper.toPublicECDSAKey((byte[])this.config.encodedServerEcPublicKey);
        }
        String string = classname = this.config.mainclass == null || this.config.mainclass.isEmpty() ? args[0] : this.config.mainclass;
        if (classname.isEmpty()) {
            LogHelper.error((String)"MainClass not found. Please set MainClass for ServerWrapper.json or first commandline argument");
            System.exit(-1);
        }
        if (this.config.oauth == null && (this.config.extendedTokens == null || this.config.extendedTokens.isEmpty())) {
            LogHelper.error((String)"Auth not configured. Please use 'java -jar ServerWrapper.jar setup'");
            System.exit(-1);
        }
        if (this.config.autoloadLibraries) {
            if (!ServerAgent.isAgentStarted()) {
                throw new UnsupportedOperationException("JavaAgent not found, autoloadLibraries not available");
            }
            if (this.config.librariesDir == null) {
                throw new UnsupportedOperationException("librariesDir is null, autoloadLibraries not available");
            }
            Path librariesDir = Paths.get(this.config.librariesDir, new String[0]);
            LogHelper.info((String)"Load libraries");
            ServerAgent.loadLibraries(librariesDir);
        }
        LogHelper.info((String)"ServerWrapper: LaunchServer address: %s. Title: %s", (Object[])new Object[]{this.config.address, Launcher.profile != null ? Launcher.profile.getTitle() : "unknown"});
        LogHelper.info((String)"Minecraft Version (for profile): %s", (Object[])new Object[]{ServerWrapper.wrapper.profile == null ? "unknown" : ServerWrapper.wrapper.profile.getVersion().toString()});
        if (this.config.args != null && !this.config.args.isEmpty()) {
            real_args = this.config.args.toArray(new String[0]);
        } else if (args.length > 0) {
            real_args = new String[args.length - 1];
            System.arraycopy(args, 1, real_args, 0, args.length - 1);
        } else {
            real_args = args;
        }
        ClientService.nativePath = this.config.nativesDir;
        ConfigService.serverName = this.config.serverName;
        if (this.config.loadNatives != null) {
            for (String string2 : this.config.loadNatives) {
                System.load(Paths.get(this.config.nativesDir, new String[0]).resolve(ClientService.findLibrary((String)string2)).toAbsolutePath().toString());
            }
        }
        switch (this.config.classLoaderConfig) {
            case LAUNCHER: {
                launch = new LegacyLaunch();
                System.setProperty("java.class.path", String.join((CharSequence)File.pathSeparator, this.config.classpath));
                break;
            }
            case MODULE: {
                launch = new ModuleLaunch();
                System.setProperty("java.class.path", String.join((CharSequence)File.pathSeparator, this.config.classpath));
                break;
            }
            default: {
                launch = ServerAgent.isAgentStarted() ? new BasicLaunch(ServerAgent.inst) : new BasicLaunch();
            }
        }
        LaunchOptions options = new LaunchOptions();
        options.enableHacks = this.config.enableHacks;
        options.moduleConf = this.config.moduleConf;
        classLoaderControl = launch.init((List)this.config.classpath.stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toCollection(ArrayList::new)), this.config.nativesDir, options);
        if (ServerAgent.isAgentStarted()) {
            ClientService.instrumentation = ServerAgent.inst;
        }
        ClientService.classLoaderControl = classLoaderControl;
        ClientService.baseURLs = classLoaderControl.getURLs();
        if (this.config.configServiceSettings != null) {
            this.config.configServiceSettings.apply();
        }
        LogHelper.info((String)"Start Minecraft Server");
        try {
            if (this.config.compatClasses != null) {
                for (String e : this.config.compatClasses) {
                    Class clazz = classLoaderControl.getClass(e);
                    MethodHandle runMethod = MethodHandles.lookup().findStatic(clazz, "run", MethodType.methodType(Void.TYPE, ClassLoaderControl.class));
                    runMethod.invoke(classLoaderControl);
                }
            }
            LogHelper.debug((String)"Invoke main method %s with %s", (Object[])new Object[]{classname, launch.getClass().getName()});
            launch.launch(this.config.mainclass, this.config.mainmodule, Arrays.asList(real_args));
        }
        catch (Throwable throwable) {
            LogHelper.error((Throwable)throwable);
            System.exit(-1);
        }
    }

    public void updateLauncherConfig() {
        LauncherConfig cfg = new LauncherConfig(this.config.address, null, null, new HashMap(), "ServerWrapper");
        Launcher.setConfig((LauncherConfig)cfg);
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public Config getDefaultConfig() {
        Config newConfig = new Config();
        newConfig.serverName = "your server name";
        newConfig.mainclass = "";
        newConfig.extendedTokens = new HashMap<String, Request.ExtendedToken>();
        newConfig.args = new ArrayList<String>();
        newConfig.classpath = new ArrayList<String>();
        newConfig.address = "ws://localhost:9274/api";
        newConfig.classLoaderConfig = ClientProfile.ClassLoaderConfig.SYSTEM_ARGS;
        newConfig.env = LauncherConfig.LauncherEnvironment.STD;
        newConfig.properties = new HashMap<String, String>();
        return newConfig;
    }

    public static final class Config {
        @Deprecated
        public String projectname;
        public String address;
        public String serverName;
        public boolean autoloadLibraries;
        public String logFile;
        public List<String> classpath;
        public ClientProfile.ClassLoaderConfig classLoaderConfig;
        public String librariesDir;
        public String mainclass;
        public String mainmodule;
        public String nativesDir = "natives";
        public List<String> args;
        public List<String> compatClasses;
        public List<String> loadNatives;
        public String authId;
        public AuthRequestEvent.OAuthRequestEvent oauth;
        public long oauthExpireTime;
        public Map<String, Request.ExtendedToken> extendedTokens;
        public LauncherConfig.LauncherEnvironment env;
        public LaunchOptions.ModuleConf moduleConf = new LaunchOptions.ModuleConf();
        public byte[] encodedServerRsaPublicKey;
        public byte[] encodedServerEcPublicKey;
        public boolean enableHacks;
        public Map<String, String> properties;
        public ConfigServiceSettings configServiceSettings = new ConfigServiceSettings();

        public static class ConfigServiceSettings {
            public boolean disableLogging = false;
            public boolean checkServerNeedProperties = false;
            public boolean checkServerNeedHardware = false;

            public void apply() {
                ConfigService.disableLogging = this.disableLogging;
                ConfigService.checkServerConfig.needHardware = this.checkServerNeedHardware;
                ConfigService.checkServerConfig.needProperties = this.checkServerNeedProperties;
            }
        }
    }
}

