/*
 * Decompiled with CFR 0.152.
 */
package pro.haichuang.framework.base.config.mvc.filter;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.io.IOUtils;
import pro.haichuang.framework.base.util.common.RequestUtils;

public class RepeatRequestWrapper
extends HttpServletRequestWrapper {
    private byte[] body = new byte[0];

    public RepeatRequestWrapper(HttpServletRequest request) throws IOException {
        super(request);
        if (RequestUtils.isJsonRequest((HttpServletRequest)this)) {
            this.body = IOUtils.toByteArray((InputStream)request.getInputStream());
        }
    }

    public BufferedReader getReader() throws IOException {
        return RequestUtils.isJsonRequest((HttpServletRequest)this) ? new BufferedReader(new InputStreamReader(new ByteArrayInputStream(this.body))) : super.getReader();
    }

    public ServletInputStream getInputStream() throws IOException {
        return RequestUtils.isJsonRequest((HttpServletRequest)this) ? new ServletInputStream(){
            private int lastIndexRetrieved = -1;
            private ReadListener readListener = null;

            public boolean isFinished() {
                return this.lastIndexRetrieved == RepeatRequestWrapper.this.body.length - 1;
            }

            public boolean isReady() {
                return this.isFinished();
            }

            public void setReadListener(ReadListener listener) {
                this.readListener = listener;
                if (!this.isFinished()) {
                    try {
                        this.readListener.onDataAvailable();
                    }
                    catch (IOException e) {
                        this.readListener.onError((Throwable)e);
                    }
                } else {
                    try {
                        this.readListener.onAllDataRead();
                    }
                    catch (IOException e) {
                        this.readListener.onError((Throwable)e);
                    }
                }
            }

            public int read() throws IOException {
                int index = -1;
                if (!this.isFinished()) {
                    index = RepeatRequestWrapper.this.body[this.lastIndexRetrieved + 1];
                    ++this.lastIndexRetrieved;
                    if (this.isFinished() && this.readListener != null) {
                        try {
                            this.readListener.onAllDataRead();
                        }
                        catch (IOException e) {
                            this.readListener.onError((Throwable)e);
                            throw e;
                        }
                    }
                }
                return index;
            }
        } : super.getInputStream();
    }
}

