/*
 * Decompiled with CFR 0.152.
 */
package pro.haichuang.framework.base.page;

import java.io.Serializable;
import java.util.Collection;
import pro.haichuang.framework.base.page.Pageable;
import pro.haichuang.framework.base.request.PageRequest;
import pro.haichuang.framework.base.response.vo.PageDetailVO;

public class PageDTO<T>
implements Pageable<T>,
Serializable {
    private static final long serialVersionUID = -4773020592878421576L;
    private Integer pageNo = 1;
    private Integer pageSize = 10;
    private Long totalCount = 0L;
    private Collection<T> content;

    public PageDTO() {
    }

    public PageDTO(int pageNo, int pageSize) {
        this();
        this.pageNo = pageNo;
        this.pageSize = pageSize;
        this.adjustPageNo();
    }

    public PageDTO(int pageNo, int pageSize, long totalCount, Collection<T> content) {
        this(pageNo, pageSize);
        this.totalCount = totalCount;
        this.content = content;
        this.adjustPageNo();
    }

    public PageDTO(PageRequest pageRequest) {
        this();
        this.pageNo = pageRequest.getPageNo();
        this.pageSize = pageRequest.getPageSize();
    }

    public PageDTO(PageRequest pageRequest, long totalCount, Collection<T> content) {
        this(pageRequest);
        this.totalCount = totalCount;
        this.content = content;
    }

    public PageDTO(PageDetailVO pageDetailVO, Collection<T> content) {
        this(pageDetailVO.getPageNo(), pageDetailVO.getPageSize(), pageDetailVO.getTotalCount(), content);
        this.adjustPageNo();
    }

    public static <T> PageDTO<T> empty() {
        return new PageDTO<T>();
    }

    @Override
    public long getTotalCount() {
        return this.totalCount;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public int getPageNo() {
        return this.pageNo;
    }

    @Override
    public int getTotalPage() {
        int totalPage = (int)(this.totalCount / (long)this.pageSize.intValue());
        if (totalPage == 0 || this.totalCount % (long)this.pageSize.intValue() != 0L) {
            ++totalPage;
        }
        return totalPage;
    }

    @Override
    public boolean isFirstPage() {
        return this.pageNo <= 1;
    }

    @Override
    public boolean isLastPage() {
        return this.pageNo >= this.getTotalPage();
    }

    @Override
    public int getNextPage() {
        if (this.isLastPage()) {
            return this.pageNo;
        }
        return this.pageNo + 1;
    }

    @Override
    public int getPrePage() {
        if (this.isFirstPage()) {
            return this.pageNo;
        }
        return this.pageNo - 1;
    }

    public PageDTO<T> setTotalCount(long totalCount) {
        this.totalCount = Math.max(totalCount, 0L);
        return this;
    }

    public PageDTO<T> setPageSize(int pageSize) {
        this.pageSize = pageSize < 1 ? Integer.valueOf(1000) : Integer.valueOf(Math.min(pageSize, 1000));
        return this;
    }

    public PageDTO<T> setPageNo(int pageNo) {
        this.pageNo = Math.max(pageNo, 1);
        this.adjustPageNo();
        return this;
    }

    @Override
    public Collection<T> getContent() {
        return this.content;
    }

    public PageDTO<T> setContent(Collection<T> content) {
        this.content = content;
        return this;
    }

    public void adjustPageNo() {
        if (this.pageNo == 1) {
            return;
        }
        int totalPage = this.getTotalPage();
        if (this.pageNo > totalPage) {
            this.pageNo = totalPage;
        }
    }

    public String toString() {
        return "PageDTO{pageNo=" + this.pageNo + ", pageSize=" + this.pageSize + ", totalCount=" + this.totalCount + ", content=" + this.content + '}';
    }
}

