/*
 * Decompiled with CFR 0.152.
 */
package pro.haichuang.framework.base.page;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.LocalDateTime;
import java.util.Collection;
import pro.haichuang.framework.base.response.vo.PageDetailVO;

public interface Pageable<T> {
    public int getPageNo();

    public int getPageSize();

    public long getTotalCount();

    @JsonIgnore
    @JSONField(serialize=false, deserialize=false)
    public int getTotalPage();

    @JsonIgnore
    @JSONField(serialize=false, deserialize=false)
    public boolean isFirstPage();

    @JsonIgnore
    @JSONField(serialize=false, deserialize=false)
    public boolean isLastPage();

    @JsonIgnore
    @JSONField(serialize=false, deserialize=false)
    public int getNextPage();

    @JsonIgnore
    @JSONField(serialize=false, deserialize=false)
    public int getPrePage();

    @JsonIgnore
    @JSONField(serialize=false, deserialize=false)
    default public int offsetPageNo() {
        return this.getPageNo() > 0 ? (this.getPageNo() - 1) * this.getPageSize() : 0;
    }

    public Collection<T> getContent();

    default public PageDetailVO convertToPageDetailVO() {
        return new PageDetailVO(this.getPageNo(), this.getPageSize(), this.getTotalCount());
    }

    public static LocalDateTime formatEndDate(LocalDateTime endDateTime) {
        return endDateTime.plusDays(1L);
    }
}

