/*
 * Decompiled with CFR 0.152.
 */
package pro.haichuang.framework.base.util.common;

import java.io.File;
import java.util.Arrays;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.lang.Nullable;
import org.springframework.web.multipart.MultipartFile;
import pro.haichuang.framework.base.util.common.UUIDUtils;

public class FileUriUtils {
    public static String concatFilename(MultipartFile file, @Nullable String newFileName, String fileType, String ... uploadPath) {
        String fileOriginalExtensionName = FilenameUtils.getExtension((String)file.getOriginalFilename());
        String fileNewName = newFileName != null && !newFileName.isEmpty() ? newFileName : (fileOriginalExtensionName != null && !fileOriginalExtensionName.isEmpty() ? UUIDUtils.random().concat(FilenameUtils.EXTENSION_SEPARATOR_STR).concat(fileOriginalExtensionName) : UUIDUtils.random());
        String relativeUploadPath = FilenameUtils.concat((String)String.join((CharSequence)"/", Arrays.asList(uploadPath)), (String)fileType);
        return FileUriUtils.formatFilename(FilenameUtils.concat((String)relativeUploadPath, (String)fileNewName), true);
    }

    public static String concatFilename(File file, @Nullable String newFileName, String fileType, String ... uploadPath) {
        String fileExtensionName = FilenameUtils.getExtension((String)file.getName());
        String fileNewName = newFileName != null && !newFileName.isEmpty() ? newFileName : (!fileExtensionName.isEmpty() ? UUIDUtils.random().concat(FilenameUtils.EXTENSION_SEPARATOR_STR).concat(fileExtensionName) : UUIDUtils.random());
        String relativeUploadPath = FilenameUtils.concat((String)String.join((CharSequence)"/", Arrays.asList(uploadPath)), (String)fileType);
        return FileUriUtils.formatFilename(FilenameUtils.concat((String)relativeUploadPath, (String)fileNewName), true);
    }

    public static String concatFilename(String filePath, @Nullable String newFileName, String fileType, String ... uploadPath) {
        String fileExtensionName = FilenameUtils.getExtension((String)filePath);
        String fileNewName = newFileName != null && !newFileName.isEmpty() ? newFileName : (!fileExtensionName.isEmpty() ? UUIDUtils.random().concat(FilenameUtils.EXTENSION_SEPARATOR_STR).concat(fileExtensionName) : UUIDUtils.random());
        String relativeUploadPath = FilenameUtils.concat((String)String.join((CharSequence)"/", Arrays.asList(uploadPath)), (String)fileType);
        return FileUriUtils.formatFilename(FilenameUtils.concat((String)relativeUploadPath, (String)fileNewName), true);
    }

    public static String formatFilename(String filename, boolean isReplaceFirstSeparator) {
        filename = FilenameUtils.separatorsToUnix((String)filename);
        return isReplaceFirstSeparator && StringUtils.equals((CharSequence)String.valueOf(filename.charAt(0)), (CharSequence)"/") ? filename.substring(1) : filename;
    }
}

