package pro.haichuang.framework.base.constant;

/**
 * 分页常量
 *
 * <p>该类主要用于存储分页的常量信息
 *
 * @author JiYinchuan
 * @version 1.0.0
 * @since 1.0.0
 */
public class PageConstant {

    // ========================= 基础 =========================

    /**
     * 默认页码
     */
    public static final int DEFAULT_PAGE_NO = 1;

    /**
     * 默认每页展示数量
     */
    public static final int DEFAULT_PAGE_SIZE = 10;

    /**
     * 默认最大每页数量
     */
    public static final int DEFAULT_MAX_PAGE_SIZE = 1000;

    /**
     * 默认总数
     */
    public static final long DEFAULT_TOTAL_COUNT = 0;

    // ========================= 字符串 =========================

    /**
     * 默认页码字符串
     */
    public static final String DEFAULT_PAGE_NO_STRING = "1";

    /**
     * 默认每页展示数量字符串
     */
    public static final String DEFAULT_PAGE_SIZE_STRING = "10";

    /**
     * 默认最大每页数量字符串
     */
    public static final String DEFAULT_MAX_PAGE_SIZE_STRING = "1000";

    /**
     * 默认总数字符串
     */
    public static final String DEFAULT_TOTAL_COUNT_STRING = "0";

}
