/*
 * Decompiled with CFR 0.152.
 */
package pro.haichuang.framework.base.config.aspect;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import pro.haichuang.framework.base.dto.HttpServletRequestDTO;
import pro.haichuang.framework.base.exception.ApplicationException;
import pro.haichuang.framework.base.util.common.RequestUtils;

@Aspect
@Order(value=1)
public class LogAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogAspect.class);
    private static final String LOG_TAG = "Request";
    @Autowired
    private ObjectMapper objectMapper;

    @Pointcut(value="@annotation(io.swagger.annotations.ApiOperation)")
    public void logPointCut() {
    }

    @Around(value="logPointCut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        long beginTime = System.currentTimeMillis();
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        Assert.notNull((Object)requestAttributes, (String)ApplicationException.DEFAULT_ERROR_USER_TIP);
        HttpServletRequest request = requestAttributes.getRequest();
        MethodSignature signature = (MethodSignature)point.getSignature();
        Method method = signature.getMethod();
        HttpServletRequestDTO httpServletRequestDTO = RequestUtils.parseInfo(request, method);
        String clientIp = httpServletRequestDTO.getClientIp();
        String apiMessage = httpServletRequestDTO.getApiMessage();
        Long userId = httpServletRequestDTO.getUserId();
        String fullMethodName = httpServletRequestDTO.getFullMethodName();
        LOGGER.info("[{}] [Begin] \u68c0\u6d4b\u5230\u8bf7\u6c42 [apiMessage: {}, requestUri: {}, method: {}, clientIp: {}, userId: {}, params: {}]", new Object[]{LOG_TAG, apiMessage, request.getRequestURI(), fullMethodName, clientIp, userId, point.getArgs()});
        Object result = point.proceed();
        long executionTime = System.currentTimeMillis() - beginTime;
        LOGGER.info("[{}] [ End ] \u68c0\u6d4b\u5230\u8bf7\u6c42 [apiMessage: {}, requestUri: {}, method: {}, clientIp: {}, userId: {}, executionTime: {}]", new Object[]{LOG_TAG, apiMessage, request.getRequestURI(), fullMethodName, clientIp, userId, executionTime});
        LOGGER.debug("[{}] \u68c0\u6d4b\u5230\u8bf7\u6c42 [apiMessage: {}, requestUri: {}, method: {}, clientIp: {}, userId: {}, executionTime: {}, params: {}, result: {}]", new Object[]{LOG_TAG, apiMessage, request.getRequestURI(), fullMethodName, clientIp, userId, executionTime, point.getArgs(), this.objectMapper.writeValueAsString(result)});
        return result;
    }
}

