/*
 * Decompiled with CFR 0.152.
 */
package pro.haichuang.framework.base.config.mvc;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.lang.Nullable;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import pro.haichuang.framework.base.enums.error.client.RequestParamErrorEnum;
import pro.haichuang.framework.base.enums.error.client.RequestServerErrorEnum;
import pro.haichuang.framework.base.exception.ApplicationException;
import pro.haichuang.framework.base.exception.EnumIllegalArgumentException;
import pro.haichuang.framework.base.exception.StackTraceException;
import pro.haichuang.framework.base.exception.ThirdPartyException;
import pro.haichuang.framework.base.response.ResultVO;
import pro.haichuang.framework.base.response.vo.BaseVO;
import pro.haichuang.framework.base.util.common.IpUtils;
import pro.haichuang.framework.base.util.jwt.SecurityUtils;

@RestControllerAdvice
public class BaseControllerAdvice {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseControllerAdvice.class);
    private static final String LOG_TAG = "\u5168\u5c40\u63a7\u5236\u5668\u5f02\u5e38\u6355\u83b7";
    private static final Pattern ENUM_ILLEGAL_ARGUMENT_PRINT_PATTERN = Pattern.compile("(\\[.*])\\s");

    @ExceptionHandler(value={ApplicationException.class})
    public BaseVO generalErrorHandle(ApplicationException e, HttpServletRequest request) {
        String clientIp = IpUtils.getIpv4Address(request);
        Long userId = SecurityUtils.getJwtPayloadOrNewInstance().getUserId();
        LOGGER.warn("[{}] ------------------------- \u81ea\u5b9a\u4e49\u5f02\u5e38\u4fe1\u606f ------------------------- [Begin]", (Object)LOG_TAG);
        this.printStackTraceFormat(request.getRequestURI(), request.getMethod(), e, e.getCause(), "\u81ea\u5b9a\u4e49\u5f02\u5e38\u4fe1\u606f", clientIp, userId, null);
        LOGGER.warn("[{}] ------------------------- \u81ea\u5b9a\u4e49\u5f02\u5e38\u4fe1\u606f ------------------------- [ End ]", (Object)LOG_TAG);
        return ResultVO.other(e.getBaseEnum(), e.getUserTip());
    }

    @ExceptionHandler(value={StackTraceException.class})
    public BaseVO stackTracerErrorHandler(StackTraceException e, HttpServletRequest request, HttpServletResponse response) {
        String clientIp = IpUtils.getIpv4Address(request);
        Long userId = SecurityUtils.getJwtPayloadOrNewInstance().getUserId();
        LOGGER.error("[{}] ------------------------- \u5806\u6808\u5f02\u5e38\u4fe1\u606f ------------------------- [Begin]", (Object)LOG_TAG);
        LOGGER.error("[{}] \u5806\u6808\u5f02\u5e38\u4fe1\u606f [requestUri: {}, requestMethod: {}, clientIp: {}, userId: {}, errorMessage: {}]", new Object[]{LOG_TAG, request.getRequestURI(), request.getMethod(), clientIp, userId, e.getLocalizedMessage(), e});
        LOGGER.error("[{}] ------------------------- \u5806\u6808\u5f02\u5e38\u4fe1\u606f ------------------------- [ End ]", (Object)LOG_TAG);
        response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        return ResultVO.other(RequestServerErrorEnum.SERVICE_ERROR, ApplicationException.DEFAULT_ERROR_USER_TIP);
    }

    @ExceptionHandler(value={ThirdPartyException.class})
    public JSONObject thirdPartyErrorHandler(ThirdPartyException e, HttpServletRequest request, HttpServletResponse response) {
        String clientIp = IpUtils.getIpv4Address(request);
        Long userId = SecurityUtils.getJwtPayloadOrNewInstance().getUserId();
        LOGGER.error("[{}] ------------------------- \u7b2c\u4e09\u65b9\u5f02\u5e38\u4fe1\u606f ------------------------- [Begin]", (Object)LOG_TAG);
        LOGGER.error("[{}] \u7b2c\u4e09\u65b9\u5f02\u5e38\u4fe1\u606f [requestUri: {}, requestMethod: {}, clientIp: {}, userId: {}, errorCode: {}, errorMessage: {}]", new Object[]{LOG_TAG, request.getRequestURI(), request.getMethod(), clientIp, userId, e.getErrorCode(), e.getErrorMessage(), e});
        LOGGER.error("[{}] ------------------------- \u7b2c\u4e09\u65b9\u5f02\u5e38\u4fe1\u606f ------------------------- [ End ]", (Object)LOG_TAG);
        response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        return new JSONObject().fluentPut("errorCode", (Object)RequestServerErrorEnum.SERVICE_ERROR.value()).fluentPut("errorMessage", (Object)e.getLocalizedMessage()).fluentPut("userTip", (Object)ApplicationException.DEFAULT_ERROR_USER_TIP);
    }

    @ExceptionHandler(value={Exception.class})
    public BaseVO serverErrorHandler(Exception e, HttpServletRequest request, HttpServletResponse response) {
        String clientIp = IpUtils.getIpv4Address(request);
        Long userId = SecurityUtils.getJwtPayloadOrNewInstance().getUserId();
        LOGGER.error("[{}] ------------------------- \u7cfb\u7edf\u5f02\u5e38\u4fe1\u606f ------------------------- [Begin]", (Object)LOG_TAG);
        LOGGER.error("[{}] \u7cfb\u7edf\u5f02\u5e38\u4fe1\u606f [requestUri: {}, requestMethod: {}, clientIp: {}, userId: {}, errorMessage: {}]", new Object[]{LOG_TAG, request.getRequestURI(), request.getMethod(), clientIp, userId, e.getLocalizedMessage(), e});
        LOGGER.error("[{}] ------------------------- \u7cfb\u7edf\u5f02\u5e38\u4fe1\u606f ------------------------- [ End ]", (Object)LOG_TAG);
        response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        return ResultVO.other(RequestServerErrorEnum.SERVICE_ERROR, ApplicationException.DEFAULT_ERROR_USER_TIP);
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public JSONObject validationExceptionHandler(MissingServletRequestParameterException e, HttpServletRequest request, HttpServletResponse response) {
        String clientIp = IpUtils.getIpv4Address(request);
        Long userId = SecurityUtils.getJwtPayloadOrNewInstance().getUserId();
        LOGGER.warn("[{}] ------------------------- \u53c2\u6570\u4e3a\u7a7a ------------------------- [Begin]", (Object)LOG_TAG);
        LOGGER.warn("[{}] \u53c2\u6570\u4e3a\u7a7a [requestUri: {}, requestMethod: {}, clientIp: {}, userId: {}, errorMessage: {}]", new Object[]{LOG_TAG, request.getRequestURI(), request.getMethod(), clientIp, userId, e.getLocalizedMessage()});
        LOGGER.warn("[{}] ------------------------- \u53c2\u6570\u4e3a\u7a7a ------------------------- [ End ]", (Object)LOG_TAG);
        response.setStatus(HttpStatus.BAD_REQUEST.value());
        return new JSONObject().fluentPut("errorCode", (Object)RequestParamErrorEnum.PARAMETER_EMPTY.value()).fluentPut("errorMessage", (Object)e.getLocalizedMessage()).fluentPut("userTip", (Object)e.getLocalizedMessage());
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    public JSONObject validationExceptionHandler(MethodArgumentTypeMismatchException e, HttpServletRequest request, HttpServletResponse response) {
        String clientIp = IpUtils.getIpv4Address(request);
        Long userId = SecurityUtils.getJwtPayloadOrNewInstance().getUserId();
        LOGGER.warn("[{}] ------------------------- \u53c2\u6570\u8f6c\u6362\u5f02\u5e38 ------------------------- [Begin]", (Object)LOG_TAG);
        String errorMessage = this.printStackTraceFormat(request.getRequestURI(), request.getMethod(), (Throwable)e, e.getCause(), "\u53c2\u6570\u8f6c\u6362\u5f02\u5e38", clientIp, userId, e.getLocalizedMessage());
        LOGGER.warn("[{}] ------------------------- \u53c2\u6570\u8f6c\u6362\u5f02\u5e38 ------------------------- [ End ]", (Object)LOG_TAG);
        response.setStatus(HttpStatus.BAD_REQUEST.value());
        return new JSONObject().fluentPut("errorCode", (Object)RequestParamErrorEnum.PARAMETER_EMPTY.value()).fluentPut("errorMessage", (Object)errorMessage).fluentPut("userTip", (Object)(e.getLocalizedMessage().equals(errorMessage) ? errorMessage : ApplicationException.DEFAULT_ERROR_USER_TIP));
    }

    @ExceptionHandler(value={ValidationException.class})
    public JSONObject validationExceptionHandler(ValidationException e, HttpServletRequest request, HttpServletResponse response) {
        String clientIp = IpUtils.getIpv4Address(request);
        Long userId = SecurityUtils.getJwtPayloadOrNewInstance().getUserId();
        LOGGER.warn("[{}] ------------------------- \u9a8c\u8bc1\u5f02\u5e38 ------------------------- [Begin]", (Object)LOG_TAG);
        LOGGER.warn("[{}] \u9a8c\u8bc1\u5f02\u5e38 [requestUri: {}, requestMethod: {}, clientIp: {}, userId: {}, errorMessage: {}]", new Object[]{LOG_TAG, request.getRequestURI(), request.getMethod(), clientIp, userId, e.getLocalizedMessage()});
        ArrayList<String> userTipMessages = new ArrayList<String>();
        Set constraintViolations = ((ConstraintViolationException)e).getConstraintViolations();
        for (ConstraintViolation constraintViolation : constraintViolations) {
            userTipMessages.add(constraintViolation.getMessage());
        }
        this.printStackTraceFormat(request.getRequestURI(), request.getMethod(), (Throwable)e, e.getCause(), "\u9a8c\u8bc1\u5f02\u5e38", clientIp, userId, null);
        LOGGER.warn("[{}] ------------------------- \u9a8c\u8bc1\u5f02\u5e38 ------------------------- [ End ]", (Object)LOG_TAG);
        response.setStatus(HttpStatus.BAD_REQUEST.value());
        return new JSONObject().fluentPut("errorCode", (Object)RequestParamErrorEnum.INVALID_INPUT.value()).fluentPut("errorMessage", (Object)e.getLocalizedMessage()).fluentPut("userTip", (Object)String.join((CharSequence)",", userTipMessages));
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public JSONObject validationExceptionHandler(HttpMessageNotReadableException e, HttpServletRequest request, HttpServletResponse response) {
        String clientIp = IpUtils.getIpv4Address(request);
        Long userId = SecurityUtils.getJwtPayloadOrNewInstance().getUserId();
        LOGGER.warn("[{}] ------------------------- \u8bf7\u6c42\u4f53\u5f02\u5e38 ------------------------- [Begin]", (Object)LOG_TAG);
        String errorMessage = this.printStackTraceFormat(request.getRequestURI(), request.getMethod(), (Throwable)e, e.getCause(), "\u8bf7\u6c42\u4f53\u5f02\u5e38", clientIp, userId, e.getLocalizedMessage());
        LOGGER.warn("[{}] \u8bf7\u6c42\u4f53\u5f02\u5e38 [requestUri: {}, requestMethod: {}, clientIp: {}, userId: {}, errorMessage: {}]", new Object[]{LOG_TAG, request.getRequestURI(), request.getMethod(), clientIp, userId, errorMessage});
        LOGGER.warn("[{}] ------------------------- \u8bf7\u6c42\u4f53\u5f02\u5e38 ------------------------- [ End ]", (Object)LOG_TAG);
        response.setStatus(HttpStatus.BAD_REQUEST.value());
        return new JSONObject().fluentPut("errorCode", (Object)RequestParamErrorEnum.PARAMETER_EMPTY.value()).fluentPut("errorMessage", (Object)errorMessage).fluentPut("userTip", (Object)(e.getLocalizedMessage().equals(errorMessage) ? errorMessage : ApplicationException.DEFAULT_ERROR_USER_TIP));
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public JSONObject validationExceptionHandler(MethodArgumentNotValidException e, HttpServletRequest request, HttpServletResponse response) {
        String clientIp = IpUtils.getIpv4Address(request);
        Long userId = SecurityUtils.getJwtPayloadOrNewInstance().getUserId();
        LOGGER.warn("[{}] ------------------------- \u8bf7\u6c42\u4f53\u9a8c\u8bc1\u5f02\u5e38 ------------------------- [Begin]", (Object)LOG_TAG);
        ArrayList<String> errorMessages = new ArrayList<String>();
        ArrayList<String> userTipMessages = new ArrayList<String>();
        for (FieldError fieldError : e.getFieldErrors()) {
            errorMessages.add(String.format("%s: %s", fieldError.getField(), fieldError.getDefaultMessage()));
            userTipMessages.add(fieldError.getDefaultMessage());
            LOGGER.warn("[{}] \u8bf7\u6c42\u4f53\u9a8c\u8bc1\u5f02\u5e38 [requestUri: {}, requestMethod: {}, clientIp: {}, userId: {}, errorType: @{}, errorMessage: {}, field: {}#{}={}]", new Object[]{LOG_TAG, request.getRequestURI(), request.getMethod(), clientIp, userId, fieldError.getCode(), fieldError.getDefaultMessage(), e.getParameter().getParameterType().getName(), fieldError.getField(), fieldError.getRejectedValue()});
        }
        LOGGER.warn("[{}] ------------------------- \u8bf7\u6c42\u4f53\u9a8c\u8bc1\u5f02\u5e38 ------------------------- [ End ]", (Object)LOG_TAG);
        response.setStatus(HttpStatus.BAD_REQUEST.value());
        return new JSONObject().fluentPut("errorCode", (Object)RequestParamErrorEnum.INVALID_INPUT.value()).fluentPut("errorMessage", (Object)String.join((CharSequence)", ", errorMessages)).fluentPut("userTip", (Object)String.join((CharSequence)", ", userTipMessages));
    }

    @ExceptionHandler(value={BindException.class})
    public JSONObject validationExceptionHandler(BindException e, HttpServletRequest request, HttpServletResponse response) {
        String clientIp = IpUtils.getIpv4Address(request);
        Long userId = SecurityUtils.getJwtPayloadOrNewInstance().getUserId();
        LOGGER.warn("[{}] ------------------------- \u7ed1\u5b9a\u5f02\u5e38 ------------------------- [Begin]", (Object)LOG_TAG);
        LOGGER.warn("[{}] \u7ed1\u5b9a\u5f02\u5e38 [requestUri: {}, requestMethod: {}, clientIp: {}, userId: {}, errorMessage: {}]", new Object[]{LOG_TAG, request.getRequestURI(), request.getMethod(), clientIp, userId, ((ObjectError)e.getAllErrors().get(0)).getDefaultMessage()});
        this.printStackTraceFormat(request.getRequestURI(), request.getMethod(), (Throwable)e, e.getCause(), "\u7ed1\u5b9a\u5f02\u5e38", clientIp, userId, null);
        LOGGER.warn("[{}] ------------------------- \u7ed1\u5b9a\u5f02\u5e38 ------------------------- [ End ]", (Object)LOG_TAG);
        response.setStatus(HttpStatus.BAD_REQUEST.value());
        return new JSONObject().fluentPut("errorCode", (Object)RequestParamErrorEnum.INVALID_INPUT.value()).fluentPut("errorMessage", (Object)((ObjectError)e.getAllErrors().get(0)).getDefaultMessage()).fluentPut("userTip", (Object)((ObjectError)e.getAllErrors().get(0)).getDefaultMessage());
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public JSONObject validationExceptionHandler(HttpRequestMethodNotSupportedException e, HttpServletRequest request, HttpServletResponse response) {
        String clientIp = IpUtils.getIpv4Address(request);
        Long userId = SecurityUtils.getJwtPayloadOrNewInstance().getUserId();
        LOGGER.warn("[{}] ------------------------- \u65b9\u6cd5\u4e0d\u88ab\u5141\u8bb8 ------------------------- [Begin]", (Object)LOG_TAG);
        LOGGER.warn("[{}] \u65b9\u6cd5\u4e0d\u88ab\u5141\u8bb8 [requestUri: {}, requestMethod: {}, clientIp: {}, userId: {}, errorMessage: {}]", new Object[]{LOG_TAG, request.getRequestURI(), request.getMethod(), clientIp, userId, e.getLocalizedMessage()});
        this.printStackTraceFormat(request.getRequestURI(), request.getMethod(), (Throwable)e, e.getCause(), "\u65b9\u6cd5\u4e0d\u88ab\u5141\u8bb8", clientIp, userId, null);
        LOGGER.warn("[{}] ------------------------- \u65b9\u6cd5\u4e0d\u88ab\u5141\u8bb8 ------------------------- [ End ]", (Object)LOG_TAG);
        response.setStatus(HttpStatus.METHOD_NOT_ALLOWED.value());
        return new JSONObject().fluentPut("errorCode", (Object)RequestParamErrorEnum.INVALID_INPUT.value()).fluentPut("errorMessage", (Object)e.getLocalizedMessage()).fluentPut("userTip", (Object)ApplicationException.DEFAULT_ERROR_USER_TIP);
    }

    @Nullable
    private String printStackTraceFormat(String requestUri, String requestMethod, Throwable tp, @Nullable Throwable t, String tag, String clientIp, @Nullable Long userId, @Nullable String originalErrorMessage) {
        if (t == null) {
            if (tp instanceof EnumIllegalArgumentException) {
                Matcher matcher = ENUM_ILLEGAL_ARGUMENT_PRINT_PATTERN.matcher(tp.getLocalizedMessage());
                originalErrorMessage = tp.getLocalizedMessage();
                if (matcher.find()) {
                    originalErrorMessage = originalErrorMessage.replace(matcher.group(), "");
                }
                LOGGER.warn("[{}] {} [requestUri: {}, requestMethod: {}, clientIp, {}, userId: {}, errorMessage: {}]", new Object[]{LOG_TAG, tag, requestUri, requestMethod, clientIp, userId, tp.getLocalizedMessage()});
            } else {
                boolean isPrintStack = false;
                for (StackTraceElement stackTraceElement : tp.getStackTrace()) {
                    if (!stackTraceElement.getClassName().contains("pro.haichuang")) continue;
                    LOGGER.warn("[{}] {} [requestUri: {}, requestMethod: {}, clientIp, {}, userId: {}, stackTrace: {}]", new Object[]{LOG_TAG, tag, requestUri, requestMethod, clientIp, userId, stackTraceElement});
                    isPrintStack = true;
                }
                if (!isPrintStack && originalErrorMessage != null) {
                    originalErrorMessage = originalErrorMessage.split(":")[0];
                }
            }
            return originalErrorMessage;
        }
        return this.printStackTraceFormat(requestUri, requestMethod, t, t.getCause(), tag, clientIp, userId, originalErrorMessage);
    }
}

