/*
 * Decompiled with CFR 0.152.
 */
package pro.haichuang.framework.base.config.swagger.factory;

import io.swagger.annotations.Api;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import pro.haichuang.framework.base.config.swagger.SwaggerInfo;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.Contact;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.service.SecurityScheme;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;

public class SwaggerFactory {
    public static final String DEFAULT_GROUP_NAME = "default";
    public static final String DEFAULT_TITLE = "HaiChuang Restful Apis";
    public static final String DEFAULT_DESCRIPTION = "HaiChuang Restful Apis Description";
    public static final String DEFAULT_TERMS_OF_SERVICE_URL = "https://www.haichuang.pro";
    public static final Contact DEFAULT_CONTACT = new Contact("JiYinchuan", "https://www.haichuang.pro", "jiyinchuan@haichuang.pro");
    public static final String DEFAULT_VERSION = "1.0.0";
    public static final Pattern IGNORE_PATTERN = Pattern.compile("^((?!common).)*$");

    public static Docket createRestApi(SwaggerInfo infoDTO) {
        Docket docket = new Docket(DocumentationType.SWAGGER_2);
        if (infoDTO.getParameters() != null && !infoDTO.getParameters().isEmpty()) {
            docket.securitySchemes(new ArrayList<SecurityScheme>(infoDTO.getParameters())).securityContexts(Collections.singletonList(SwaggerFactory.securityContext(infoDTO.getParameters())));
        }
        String groupName = infoDTO.getGroupName() != null && !infoDTO.getGroupName().isEmpty() ? infoDTO.getGroupName() : DEFAULT_GROUP_NAME;
        Predicate predicate = infoDTO.getBasePackage() != null && !infoDTO.getBasePackage().isEmpty() ? RequestHandlerSelectors.basePackage((String)infoDTO.getBasePackage()) : RequestHandlerSelectors.withClassAnnotation(Api.class);
        return docket.apiInfo(SwaggerFactory.apiInfo(infoDTO)).groupName(groupName).select().apis(predicate).paths(PathSelectors.any()).build().extensions(infoDTO.getOpenApiExtensionResolver().buildExtensions(groupName));
    }

    private static ApiInfo apiInfo(SwaggerInfo infoDTO) {
        return new ApiInfoBuilder().title(StringUtils.isNotBlank((CharSequence)infoDTO.getTitle()) ? infoDTO.getTitle() : DEFAULT_TITLE).description(StringUtils.isNotBlank((CharSequence)infoDTO.getDescription()) ? infoDTO.getDescription() : DEFAULT_DESCRIPTION).termsOfServiceUrl(StringUtils.isNotBlank((CharSequence)infoDTO.getTermsOfServiceUrl()) ? infoDTO.getTermsOfServiceUrl() : DEFAULT_TERMS_OF_SERVICE_URL).contact(infoDTO.getContact() != null ? infoDTO.getContact() : DEFAULT_CONTACT).version(StringUtils.isNotBlank((CharSequence)infoDTO.getVersion()) ? infoDTO.getVersion() : DEFAULT_VERSION).build();
    }

    private static SecurityContext securityContext(List<SecurityScheme> parameters) {
        AuthorizationScope[] authorizationScopes = new AuthorizationScope[]{new AuthorizationScope("web", "access_token")};
        return SecurityContext.builder().securityReferences(parameters.stream().map(parameter -> new SecurityReference(parameter.getName(), authorizationScopes)).collect(Collectors.toList())).forPaths(path -> IGNORE_PATTERN.matcher((CharSequence)path).matches()).build();
    }
}

