/*
 * Decompiled with CFR 0.152.
 */
package pro.haichuang.framework.base.exception;

import org.springframework.lang.Nullable;
import pro.haichuang.framework.base.enums.BaseEnum;

public class ApplicationException
extends RuntimeException {
    private static final long serialVersionUID = 6539659393927269036L;
    public static String DEFAULT_ERROR_USER_TIP = "\u7f51\u7edc\u5f00\u5c0f\u5dee\u4e86, \u8bf7\u7a0d\u540e\u518d\u8bd5 (\u256f\ufe4f\u2570)";
    protected String errorCode;
    protected String errorMessage;
    protected String userTip;
    protected BaseEnum baseEnum;

    public ApplicationException(BaseEnum baseEnum) {
        super("errorCode: " + baseEnum.value() + ", errorMessage: " + baseEnum.getReasonPhrase());
        this.errorCode = baseEnum.value();
        this.errorMessage = baseEnum.getReasonPhrase();
        this.baseEnum = baseEnum;
        this.userTip = DEFAULT_ERROR_USER_TIP;
    }

    public ApplicationException(BaseEnum baseEnum, @Nullable String userTip) {
        super("errorCode: " + baseEnum.value() + ", errorMessage: " + baseEnum.getReasonPhrase() + ", userTip: " + userTip);
        this.errorCode = baseEnum.value();
        this.errorMessage = baseEnum.getReasonPhrase();
        this.userTip = userTip == null || userTip.isEmpty() ? DEFAULT_ERROR_USER_TIP : userTip;
        this.baseEnum = baseEnum;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getUserTip() {
        return this.userTip;
    }

    public void setUserTip(String userTip) {
        this.userTip = userTip;
    }

    public BaseEnum getBaseEnum() {
        return this.baseEnum;
    }

    public void setBaseEnum(BaseEnum baseEnum) {
        this.baseEnum = baseEnum;
    }
}

