/*
 * Decompiled with CFR 0.152.
 */
package pro.haichuang.framework.base.util.jwt;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SignatureException;
import org.springframework.lang.NonNull;
import pro.haichuang.framework.base.util.jwt.JwtPayload;

public class JwtUtils {
    @NonNull
    public static String generateJwt(@NonNull JwtPayload payload, @NonNull String secret) {
        return Jwts.builder().setId(payload.getJti()).setIssuer(payload.getIss()).setIssuedAt(payload.getIat()).setExpiration(payload.getExp()).setNotBefore(payload.getNbf()).setAudience(payload.getAud()).setSubject(payload.getSub()).claim("userId", (Object)payload.getUserId()).claim("internal", (Object)payload.isInternal()).signWith(SignatureAlgorithm.HS256, secret).compact();
    }

    @NonNull
    public static JwtPayload parseJwtToken(@NonNull String token, @NonNull String secret) throws ExpiredJwtException, MalformedJwtException, SignatureException {
        Claims claims = (Claims)Jwts.parser().setSigningKey(secret).parseClaimsJws(token).getBody();
        JwtPayload jwtPayload = new JwtPayload();
        jwtPayload.setJti(claims.getId());
        jwtPayload.setIss(claims.getIssuer());
        jwtPayload.setIat(claims.getIssuedAt());
        jwtPayload.setExp(claims.getExpiration());
        jwtPayload.setNbf(claims.getNotBefore());
        jwtPayload.setAud(claims.getAudience());
        jwtPayload.setSub(claims.getSubject());
        jwtPayload.setUserId((Long)claims.get("userId", Long.class));
        jwtPayload.setInternal((Boolean)claims.get("internal", Boolean.class));
        return jwtPayload;
    }
}

