/*
 * Decompiled with CFR 0.152.
 */
package pro.haichuang.framework.base.config.aspect;

import cn.hutool.core.thread.ThreadFactoryBuilder;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.core.annotation.Order;
import pro.haichuang.framework.base.config.properties.BaseConfigProperties;
import pro.haichuang.framework.base.enums.error.server.ExecutionErrorEnum;
import pro.haichuang.framework.base.exception.server.ExecutionException;

@Aspect
@Order(value=2)
public class RequestTimeoutAspect {
    @Autowired
    private ServerProperties serverProperties;
    @Autowired
    private BaseConfigProperties baseConfigProperties;
    private static ExecutorService executorService;

    @PostConstruct
    public void init() {
        executorService = new ThreadPoolExecutor(this.serverProperties.getTomcat().getThreads().getMinSpare(), this.serverProperties.getTomcat().getThreads().getMax(), 30L, TimeUnit.MINUTES, new LinkedBlockingDeque<Runnable>(this.serverProperties.getTomcat().getThreads().getMax()), new ThreadFactoryBuilder().setNamePrefix("RequestTimeoutAspect-Thread-%d").build(), new ThreadPoolExecutor.AbortPolicy());
    }

    @Pointcut(value="@annotation(io.swagger.annotations.ApiOperation)")
    public void logPointCut() {
    }

    @Around(value="logPointCut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Duration requestTimeoutTime;
        long beginTime = System.currentTimeMillis();
        Future<Object> future = executorService.submit(() -> {
            try {
                return point.proceed();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        });
        do {
            if (future.isDone()) {
                return future.get();
            }
            requestTimeoutTime = this.baseConfigProperties.getRequestTimeoutTime();
        } while (System.currentTimeMillis() - beginTime <= requestTimeoutTime.toMillis());
        future.cancel(true);
        throw new ExecutionException(ExecutionErrorEnum.EXECUTION_TIMEOUT);
    }
}

