/*
 * Decompiled with CFR 0.152.
 */
package pro.haichuang.framework.base.config.mvc.enums;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.lang.NonNull;
import pro.haichuang.framework.base.annotation.EnumConvertValue;
import pro.haichuang.framework.base.enums.BaseEnum;
import pro.haichuang.framework.base.exception.EnumIllegalArgumentException;

public class EnumConverterFactory
implements ConverterFactory<String, Enum<?>> {
    private static final Map<Class<? extends Enum<?>>, EnumConverterHolder> CONVERTER_MAP = new ConcurrentHashMap();

    @NonNull
    public <T extends Enum<?>> Converter<String, T> getConverter(@NonNull Class<T> targetType) {
        EnumConverterHolder holder = CONVERTER_MAP.computeIfAbsent(targetType, x$0 -> EnumConverterHolder.create(x$0));
        return holder.annotationConverter != null ? holder.annotationConverter : holder.baseEnumConverter;
    }

    static class StringToAnnotationEnumConverter<T extends Enum<?>>
    implements Converter<String, T> {
        private final Method method;

        StringToAnnotationEnumConverter(Method method) {
            this.method = method;
            this.method.setAccessible(true);
        }

        public T convert(@NonNull String source) {
            if (source.isEmpty()) {
                return null;
            }
            try {
                return (T)((Enum)this.method.invoke(null, source));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    static class StringToBaseEnumConverter<T extends BaseEnum>
    implements Converter<String, T> {
        private final Class<T> enumType;

        StringToBaseEnumConverter(Class<T> enumType) {
            this.enumType = enumType;
        }

        public T convert(@NonNull String source) {
            return BaseEnum.resolve(source, this.enumType);
        }
    }

    static class EnumConverterHolder {
        private final StringToAnnotationEnumConverter<?> annotationConverter;
        private final StringToBaseEnumConverter<?> baseEnumConverter;

        public EnumConverterHolder(StringToAnnotationEnumConverter<?> converter, StringToBaseEnumConverter<?> baseEnumConverter) {
            this.annotationConverter = converter;
            this.baseEnumConverter = baseEnumConverter;
        }

        private static EnumConverterHolder create(Class<?> targetType) {
            Method[] allDeclaredMethods;
            ArrayList<Method> enumConvertValueMethods = new ArrayList<Method>();
            for (Method declaredMethod : allDeclaredMethods = targetType.getDeclaredMethods()) {
                if (declaredMethod.getAnnotation(EnumConvertValue.class) == null) continue;
                enumConvertValueMethods.add(declaredMethod);
            }
            if (enumConvertValueMethods.isEmpty()) {
                if (BaseEnum.class.isAssignableFrom(targetType)) {
                    return EnumConverterHolder.instance(targetType);
                }
                return new EnumConverterHolder(null, null);
            }
            if (enumConvertValueMethods.size() != 1) {
                throw new EnumIllegalArgumentException("@EnumConvertValue can only be marked on one method");
            }
            Method enumConvertValueMethod = (Method)enumConvertValueMethods.get(0);
            boolean isStatic = Modifier.isStatic(enumConvertValueMethod.getModifiers());
            if (!isStatic) {
                throw new EnumIllegalArgumentException("@EnumConvertValue can only be marked on static method");
            }
            return new EnumConverterHolder(new StringToAnnotationEnumConverter(enumConvertValueMethod), null);
        }

        private static <T extends BaseEnum> EnumConverterHolder instance(Class<T> targetType) {
            return new EnumConverterHolder(null, new StringToBaseEnumConverter<T>(targetType));
        }
    }
}

