/*
 * Decompiled with CFR 0.152.
 */
package pro.haichuang.framework.base.config.aspect;

import cn.hutool.core.thread.ThreadFactoryBuilder;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.core.annotation.Order;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import pro.haichuang.framework.base.annotation.LogSave;
import pro.haichuang.framework.base.config.interceptor.AbstractLogSave;
import pro.haichuang.framework.base.util.common.IpUtils;
import pro.haichuang.framework.base.util.jwt.SecurityUtils;

@Aspect
@Order(value=3)
@ConditionalOnBean(value={AbstractLogSave.class})
public class LogSaveAspect {
    @Autowired
    private ServerProperties serverProperties;
    @Autowired
    private AbstractLogSave abstractLogSave;
    private static ExecutorService executorService;

    @PostConstruct
    public void init() {
        executorService = new ThreadPoolExecutor(this.serverProperties.getTomcat().getThreads().getMinSpare(), this.serverProperties.getTomcat().getThreads().getMax(), 30L, TimeUnit.MINUTES, new LinkedBlockingDeque<Runnable>(Math.min(this.serverProperties.getTomcat().getThreads().getMax(), 1024)), new ThreadFactoryBuilder().setNamePrefix("LogSaveAspect-Thread-%d").build(), new ThreadPoolExecutor.AbortPolicy());
    }

    @Pointcut(value="@annotation(pro.haichuang.framework.base.annotation.LogSave)")
    public void logPointCut() {
    }

    @Around(value="logPointCut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        long beginTime = System.currentTimeMillis();
        LogSave logSave = null;
        Api api = null;
        ApiOperation apiOperation = null;
        String clientIp = null;
        String fullMethodName = null;
        Long userId = null;
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null) {
            HttpServletRequest request = requestAttributes.getRequest();
            clientIp = IpUtils.getIpv4Address(request);
            MethodSignature signature = (MethodSignature)point.getSignature();
            Method method = signature.getMethod();
            logSave = method.getAnnotation(LogSave.class);
            api = method.getDeclaringClass().getAnnotation(Api.class);
            apiOperation = method.getAnnotation(ApiOperation.class);
            fullMethodName = point.getTarget().getClass().getName() + "." + method.getName() + "()";
            userId = SecurityUtils.getJwtPayloadOrNewInstance().getUserId();
        }
        Object result = point.proceed();
        long executionTime = System.currentTimeMillis() - beginTime;
        LogSave finalLogSave = logSave;
        Api finalApi = api;
        ApiOperation finalApiOperation = apiOperation;
        String finalClientIp = clientIp;
        String finalFullMethodName = fullMethodName;
        Long finalUserId = userId;
        executorService.execute(() -> this.abstractLogSave.saveLog(finalLogSave, finalApi, finalApiOperation, finalClientIp, finalFullMethodName, finalUserId, executionTime));
        return result;
    }
}

