/*
 * Decompiled with CFR 0.152.
 */
package pro.haichuang.framework.base.config.mvc;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.ToStringSerializer;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.Nullable;
import pro.haichuang.framework.base.enums.BaseEnum;

@Configuration(proxyBeanMethods=false)
public class FastJsonConfig {
    @Bean
    @ConditionalOnMissingBean(value={com.alibaba.fastjson.support.config.FastJsonConfig.class})
    public com.alibaba.fastjson.support.config.FastJsonConfig fastJsonConfig() {
        com.alibaba.fastjson.support.config.FastJsonConfig fastJsonConfig = new com.alibaba.fastjson.support.config.FastJsonConfig();
        SerializeConfig globalInstance = SerializeConfig.globalInstance;
        globalInstance.put(BigInteger.class, (ObjectSerializer)ToStringSerializer.instance);
        globalInstance.put(Long.class, (ObjectSerializer)ToStringSerializer.instance);
        globalInstance.put(Long.TYPE, (ObjectSerializer)ToStringSerializer.instance);
        globalInstance.put(LocalDateTime.class, (ObjectSerializer)DateSerializer.INSTANCE);
        globalInstance.put(LocalDate.class, (ObjectSerializer)DateSerializer.INSTANCE);
        globalInstance.put(LocalTime.class, (ObjectSerializer)DateSerializer.INSTANCE);
        globalInstance.put(BaseEnum.class, (ObjectSerializer)EnumSerializer.INSTANCE);
        fastJsonConfig.setSerializeConfig(globalInstance);
        fastJsonConfig.setSerializerFeatures(new SerializerFeature[]{SerializerFeature.WriteEnumUsingToString, SerializerFeature.WriteNullListAsEmpty});
        JSON.DEFAULT_GENERATE_FEATURE = JSON.DEFAULT_GENERATE_FEATURE | SerializerFeature.WriteEnumUsingToString.getMask() | SerializerFeature.WriteNullListAsEmpty.getMask();
        fastJsonConfig.setDateFormat("yyyy-MM-dd HH:mm:ss");
        return fastJsonConfig;
    }

    public static class EnumSerializer
    implements ObjectSerializer {
        public static final DateSerializer INSTANCE = new DateSerializer();

        public void write(JSONSerializer serializer, @Nullable Object object, Object fieldName, Type fieldType, int features) {
            SerializeWriter out = serializer.out;
            if (object == null) {
                out.writeNull();
                return;
            }
            BaseEnum val = (BaseEnum)object;
            out.writeString(val.value());
        }
    }

    public static class DateSerializer
    implements ObjectSerializer {
        public static final DateSerializer INSTANCE = new DateSerializer();

        public void write(JSONSerializer serializer, @Nullable Object object, Object fieldName, Type fieldType, int features) {
            SerializeWriter out = serializer.out;
            if (object == null) {
                out.writeNull();
                return;
            }
            Temporal val = (Temporal)object;
            if (val instanceof LocalDateTime) {
                out.writeString(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(val));
            } else if (val instanceof LocalDate) {
                out.writeString(DateTimeFormatter.ofPattern("yyyy-MM-dd").format(val));
            } else if (val instanceof LocalTime) {
                out.writeString(DateTimeFormatter.ofPattern("HH:mm:ss").format(val));
            }
        }
    }
}

