/*
 * Decompiled with CFR 0.152.
 */
package pro.haichuang.framework.base.response;

import java.io.Serializable;
import java.util.Collection;
import pro.haichuang.framework.base.enums.BaseEnum;
import pro.haichuang.framework.base.enums.success.SuccessEnum;
import pro.haichuang.framework.base.page.Pageable;
import pro.haichuang.framework.base.response.vo.BaseVO;
import pro.haichuang.framework.base.response.vo.MultiVO;
import pro.haichuang.framework.base.response.vo.PageVO;
import pro.haichuang.framework.base.response.vo.SingleVO;

public final class ResultVO
implements Serializable {
    private static final long serialVersionUID = -7437022394115877815L;

    public static BaseVO ok() {
        return new BaseVO(SuccessEnum.OK);
    }

    public static BaseVO ok(String userTip) {
        return new BaseVO(SuccessEnum.OK, userTip);
    }

    public static BaseVO ok(Boolean operationResult) {
        return new BaseVO(SuccessEnum.OK, String.valueOf(operationResult));
    }

    public static <T> SingleVO<T> okOfSingle(T data) {
        return new SingleVO<T>((BaseEnum)SuccessEnum.OK, data);
    }

    public static <T> SingleVO<T> okOfSingle(T data, String userTip) {
        return new SingleVO<T>(SuccessEnum.OK, data, userTip);
    }

    public static <T> MultiVO<T> okOfMulti(Collection<T> data) {
        return new MultiVO<T>((BaseEnum)SuccessEnum.OK, data);
    }

    public static <T> MultiVO<T> okOfMulti(Collection<T> data, String userTip) {
        return new MultiVO<T>(SuccessEnum.OK, data, userTip);
    }

    public static <T> PageVO<T> okOfPage(Pageable<T> simplePage) {
        return new PageVO<T>(SuccessEnum.OK, simplePage.convertToPageDetailVO(), simplePage.getContent());
    }

    public static <T> PageVO<T> okOfPage(Pageable<T> simplePage, String userTip) {
        return new PageVO<T>(SuccessEnum.OK, simplePage.convertToPageDetailVO(), simplePage.getContent(), userTip);
    }

    public static BaseVO other(BaseEnum baseEnum) {
        return new BaseVO(baseEnum);
    }

    public static BaseVO other(BaseEnum baseEnum, String userTip) {
        return new BaseVO(baseEnum, userTip);
    }

    public static <T> SingleVO<T> otherOfSingle(BaseEnum baseEnum, T data) {
        return new SingleVO<T>(baseEnum, data);
    }

    public static <T> SingleVO<T> otherOfSingle(BaseEnum baseEnum, T data, String userTip) {
        return new SingleVO<T>(baseEnum, data, userTip);
    }

    public static <T> MultiVO<T> otherOfMulti(BaseEnum baseEnum, Collection<T> data) {
        return new MultiVO<T>(baseEnum, data);
    }

    public static <T> MultiVO<T> otherOfMulti(BaseEnum baseEnum, Collection<T> data, String userTip) {
        return new MultiVO<T>(baseEnum, data, userTip);
    }

    public static <T> PageVO<T> otherOfPage(BaseEnum baseEnum, Pageable<T> simplePage) {
        return new PageVO<T>(baseEnum, simplePage.convertToPageDetailVO(), simplePage.getContent());
    }

    public static <T> PageVO<T> otherOfPage(BaseEnum baseEnum, Pageable<T> simplePage, String userTip) {
        return new PageVO<T>(baseEnum, simplePage.convertToPageDetailVO(), simplePage.getContent(), userTip);
    }

    public String toString() {
        return super.toString();
    }
}

