/*
 * Decompiled with CFR 0.152.
 */
package pro.haichuang.framework.base.util.common;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.lang.NonNull;
import pro.haichuang.framework.base.dto.HttpServletRequestDTO;
import pro.haichuang.framework.base.util.common.IpUtils;
import pro.haichuang.framework.base.util.jwt.SecurityUtils;

public class RequestUtils {
    @NonNull
    public static HttpServletRequestDTO parseInfo(@NonNull HttpServletRequest request, @NonNull Method method) {
        String clientIp = IpUtils.getIpv4Address(request);
        List parameterFullNameList = Arrays.stream(method.getParameters()).collect(ArrayList::new, (result, item) -> result.add(item.getType().getName().concat(" ").concat(item.getName())), List::addAll);
        String fullMethodName = String.format("%s.%s(%s)", method.getDeclaringClass().getName(), method.getName(), String.join((CharSequence)", ", parameterFullNameList));
        Api apiAnnotation = method.getDeclaringClass().getAnnotation(Api.class);
        ApiOperation apiOperationAnnotation = method.getAnnotation(ApiOperation.class);
        String methodDescription = apiAnnotation != null && apiAnnotation.tags().length > 0 ? String.join((CharSequence)",", apiAnnotation.tags()) : "";
        methodDescription = methodDescription + (apiOperationAnnotation != null && !apiOperationAnnotation.value().isEmpty() ? "-".concat(apiOperationAnnotation.value()) : "");
        Long userId = SecurityUtils.getJwtPayloadOrNewInstance().getUserId();
        return new HttpServletRequestDTO().setClientIp(clientIp).setApiMessage(methodDescription).setUserId(userId).setFullMethodName(fullMethodName);
    }

    public static boolean isJsonRequest(@NonNull HttpServletRequest request) {
        String contentTypeInHeaderValue = request.getHeader("Content-Type");
        return contentTypeInHeaderValue != null && contentTypeInHeaderValue.contains("application/json");
    }
}

